/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.virtual;

import java.util.Collection;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateReferenceMap;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.WeakIdentityCollection;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVISProvider
implements VirtualItemStateProvider,
ItemStateListener {
    private static Logger log;
    private VirtualNodeState root = null;
    protected final NodeId rootNodeId;
    protected final NodeTypeRegistry ntReg;
    private ItemStateReferenceMap nodes = new ItemStateReferenceMap();
    private final transient Collection listeners = new WeakIdentityCollection(5);
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractVISProvider(NodeTypeRegistry ntReg, NodeId rootNodeId) {
        this.ntReg = ntReg;
        this.rootNodeId = rootNodeId;
    }

    protected abstract VirtualNodeState createRootNodeState() throws RepositoryException;

    public boolean hasItemState(ItemId id) {
        if (id instanceof NodeId) {
            if (this.nodes.contains(id)) {
                return true;
            }
            if (id.equals(this.rootNodeId)) {
                return true;
            }
            return this.internalHasNodeState((NodeId)id);
        }
        return this.internalHasPropertyState((PropertyId)id);
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (id instanceof NodeId) {
            ItemState s = this.nodes.contains(id) ? this.nodes.get(id) : (id.equals(this.rootNodeId) ? this.getRootState() : this.cache(this.internalGetNodeState((NodeId)id)));
            return s;
        }
        return this.internalGetPropertyState((PropertyId)id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return false;
    }

    public boolean isVirtualRoot(ItemId id) {
        return id.equals(this.rootNodeId);
    }

    public NodeId getVirtualRootId() {
        return this.rootNodeId;
    }

    public synchronized NodeState getRootState() throws ItemStateException {
        try {
            if (this.root == null) {
                this.root = this.createRootNodeState();
            }
            return this.root;
        }
        catch (RepositoryException e) {
            throw new ItemStateException("Error creating root node state", e);
        }
    }

    protected abstract boolean internalHasNodeState(NodeId var1);

    protected abstract VirtualNodeState internalGetNodeState(NodeId var1) throws NoSuchItemStateException, ItemStateException;

    protected boolean internalHasPropertyState(PropertyId id) {
        try {
            NodeState parent = (NodeState)this.getItemState(id.getParentId());
            if (parent instanceof VirtualNodeState) {
                return parent.hasPropertyName(id.getName());
            }
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return false;
    }

    protected VirtualPropertyState internalGetPropertyState(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodeState parent = (NodeState)this.getItemState(id.getParentId());
        if (parent instanceof VirtualNodeState) {
            return ((VirtualNodeState)parent).getProperty(id.getName());
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public VirtualPropertyState createPropertyState(VirtualNodeState parent, Name name, int type, boolean multiValued) throws RepositoryException {
        PropertyId id = new PropertyId(parent.getNodeId(), name);
        VirtualPropertyState prop = new VirtualPropertyState(id);
        prop.setType(type);
        prop.setMultiValued(multiValued);
        return prop;
    }

    public VirtualNodeState createNodeState(VirtualNodeState parent, Name name, NodeId id, Name nodeTypeName) throws RepositoryException {
        if (id == null) {
            id = new NodeId(UUID.randomUUID());
        }
        VirtualNodeState state = new VirtualNodeState(this, parent.getNodeId(), id, nodeTypeName, new Name[0]);
        this.cache(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ItemStateListener listener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            if (!$assertionsDisabled && this.listeners.contains(listener)) {
                throw new AssertionError();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ItemStateListener listener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    protected NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    protected NodeState cache(NodeState state) {
        if (state != null) {
            this.nodes.put(state);
            log.debug("item added to cache. size=" + this.nodes.size());
        }
        return state;
    }

    protected void evict(NodeId id) {
        this.nodes.remove(id);
    }

    public void invalidateItem(ItemId id, boolean recursive) {
        VirtualNodeState state;
        VirtualNodeState virtualNodeState = state = id.equals(this.rootNodeId) ? this.root : (VirtualNodeState)this.nodes.get(id);
        if (state != null) {
            if (recursive) {
                VirtualPropertyState[] props = state.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    props[i].notifyStateUpdated();
                }
                Iterator iter = state.getChildNodeEntries().iterator();
                while (iter.hasNext()) {
                    ChildNodeEntry pe = (ChildNodeEntry)iter.next();
                    this.invalidateItem(pe.getId(), true);
                }
            }
            state.notifyStateUpdated();
        }
    }

    protected PropDef getApplicablePropertyDef(NodeState parent, Name propertyName, int type, boolean multiValued) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicablePropertyDef(propertyName, type, multiValued);
    }

    protected NodeDef getApplicableChildNodeDef(NodeState parent, Name nodeName, Name nodeTypeName) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicableChildNodeDef(nodeName, nodeTypeName, this.getNodeTypeRegistry());
    }

    protected EffectiveNodeType getEffectiveNodeType(NodeState parent) throws RepositoryException {
        try {
            NodeTypeRegistry ntReg = this.getNodeTypeRegistry();
            return ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + parent.getNodeId();
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateCreated(ItemState created) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateCreated(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateModified(ItemState modified) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateModified(modified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateDestroyed(ItemState destroyed) {
        ItemStateListener[] la;
        if (destroyed.isNode() && destroyed.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        this.evict((NodeId)destroyed.getId());
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDestroyed(destroyed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateDiscarded(ItemState discarded) {
        ItemStateListener[] la;
        if (discarded.isNode() && discarded.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        this.evict((NodeId)discarded.getId());
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDiscarded(discarded);
        }
    }

    static {
        $assertionsDisabled = !AbstractVISProvider.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)AbstractVISProvider.class);
    }
}

