/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.ReferenceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger((Class)SessionImporter.class);
    private final SessionImpl session;
    private final NodeImpl importTargetNode;
    private final int uuidBehavior;
    private Stack parents;
    private final ReferenceChangeTracker refTracker;

    public SessionImporter(NodeImpl importTargetNode, SessionImpl session, int uuidBehavior) {
        this.importTargetNode = importTargetNode;
        this.session = session;
        this.uuidBehavior = uuidBehavior;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(importTargetNode);
    }

    protected NodeImpl createNode(NodeImpl parent, Name nodeName, Name nodeTypeName, Name[] mixinNames, NodeId id) throws RepositoryException {
        UUID uuid = id == null ? null : id.getUUID();
        NodeImpl node = parent.addNode(nodeName, nodeTypeName, uuid);
        if (mixinNames != null) {
            for (int i = 0; i < mixinNames.length; ++i) {
                node.addMixin(mixinNames[i]);
            }
        }
        return node;
    }

    protected NodeImpl resolveUUIDConflict(NodeImpl parent, NodeImpl conflicting, NodeInfo nodeInfo) throws RepositoryException {
        NodeImpl node;
        if (this.uuidBehavior == 0) {
            node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            if (node.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                this.refTracker.mappedUUID(nodeInfo.getId().getUUID(), node.getNodeId().getUUID());
            }
        } else {
            if (this.uuidBehavior == 3) {
                if (conflicting.isNodeType(NameConstants.MIX_SHAREABLE)) {
                    parent.clone(conflicting, nodeInfo.getName());
                    return null;
                }
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                if (this.importTargetNode.getPath().startsWith(conflicting.getPath())) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                conflicting.remove();
                node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                if (conflicting.getDepth() == 0) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = (NodeImpl)conflicting.getParent();
                node = parent.replaceChildNode(nodeInfo.getId(), nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return node;
    }

    public void start() throws RepositoryException {
    }

    public void startNode(NodeInfo nodeInfo, List propInfos) throws RepositoryException {
        NodeImpl existing;
        NodeDefinition def;
        NodeImpl parent = (NodeImpl)this.parents.peek();
        NodeImpl node = null;
        NodeId id = nodeInfo.getId();
        Name nodeName = nodeInfo.getName();
        Name ntName = nodeInfo.getNodeTypeName();
        Name[] mixins = nodeInfo.getMixinNames();
        if (parent == null) {
            this.parents.push(null);
            log.debug("Skipping node: " + nodeName);
            return;
        }
        if (!this.session.getAccessManager().isGranted(this.session.getQPath(parent.getPath()), nodeName, 128)) {
            throw new AccessDeniedException("Insufficient permission.");
        }
        if (parent.hasNode(nodeName) && !(def = (existing = parent.getNode(nodeName)).getDefinition()).allowsSameNameSiblings()) {
            if (def.isProtected() && existing.isNodeType(ntName)) {
                this.parents.push(null);
                log.debug("Skipping protected node: " + existing);
                return;
            }
            if (def.isAutoCreated() && existing.isNodeType(ntName)) {
                node = existing;
            } else if (!existing.getId().equals(id) || this.uuidBehavior != 1 && this.uuidBehavior != 2) {
                throw new ItemExistsException("Node with the same UUID exists:" + existing);
            }
        }
        if (node == null) {
            if (id == null) {
                node = this.createNode(parent, nodeName, ntName, mixins, null);
            } else {
                NodeImpl conflicting;
                try {
                    conflicting = this.session.getNodeById(id);
                }
                catch (ItemNotFoundException infe) {
                    conflicting = null;
                }
                if (conflicting != null) {
                    node = this.resolveUUIDConflict(parent, conflicting, nodeInfo);
                    if (node == null) {
                        this.parents.push(null);
                        log.debug("skipping existing node " + nodeInfo.getName());
                        return;
                    }
                } else {
                    node = this.createNode(parent, nodeName, ntName, mixins, id);
                }
            }
        }
        Iterator iter = propInfos.iterator();
        while (iter.hasNext()) {
            PropInfo pi = (PropInfo)iter.next();
            pi.apply(node, this.session, this.refTracker);
        }
        this.parents.push(node);
    }

    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        this.parents.pop();
    }

    public void end() throws RepositoryException {
        Iterator iter = this.refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            PropertyImpl prop = (PropertyImpl)iter.next();
            if (prop.getType() != 9) continue;
            if (prop.isMultiple()) {
                Value[] values = prop.getValues();
                Value[] newVals = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value val = values[i];
                    UUID original = UUID.fromString((String)val.getString());
                    UUID adjusted = this.refTracker.getMappedUUID(original);
                    newVals[i] = adjusted != null ? new ReferenceValue(this.session.getNodeByUUID(adjusted)) : val;
                }
                prop.setValue(newVals);
                continue;
            }
            Value val = prop.getValue();
            UUID original = UUID.fromString((String)val.getString());
            UUID adjusted = this.refTracker.getMappedUUID(original);
            if (adjusted == null) continue;
            prop.setValue(this.session.getNodeByUUID(adjusted));
        }
        this.refTracker.clear();
    }
}

