/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public class BidiUtils {
    public static final String DIR_PROPERTY_NAME = "dir";
    private static final String DIR_PROPERTY_VALUE_RTL = "rtl";
    private static final String DIR_PROPERTY_VALUE_LTR = "ltr";

    public static HasDirection.Direction getDirectionOnElement(Element elem) {
        String dirPropertyValue = DOM.getElementProperty(elem, DIR_PROPERTY_NAME);
        if (DIR_PROPERTY_VALUE_RTL.equalsIgnoreCase(dirPropertyValue)) {
            return HasDirection.Direction.RTL;
        }
        if (DIR_PROPERTY_VALUE_LTR.equalsIgnoreCase(dirPropertyValue)) {
            return HasDirection.Direction.LTR;
        }
        return HasDirection.Direction.DEFAULT;
    }

    public static void setDirectionOnElement(Element elem, HasDirection.Direction direction) {
        switch (direction) {
            case RTL: {
                DOM.setElementProperty(elem, DIR_PROPERTY_NAME, DIR_PROPERTY_VALUE_RTL);
                break;
            }
            case LTR: {
                DOM.setElementProperty(elem, DIR_PROPERTY_NAME, DIR_PROPERTY_VALUE_LTR);
                break;
            }
            case DEFAULT: {
                if (BidiUtils.getDirectionOnElement(elem) == HasDirection.Direction.DEFAULT) break;
                DOM.setElementProperty(elem, DIR_PROPERTY_NAME, "");
            }
        }
    }
}

