/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.flex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.flex.FlexRemote;
import org.jboss.seam.flex.MessageBrokerManager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.AbstractFilter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.flex.flexFilter")
@Startup
@Install(precedence=0, value=false)
@BypassInterceptors
@Filter
public class FlexFilter
extends AbstractFilter {
    private static final LogProvider log = Logging.getLogProvider(FlexFilter.class);
    MessageBrokerManager messageBrokerManager;
    List<Class<?>> scanned = new ArrayList();

    private AnnotationDeploymentHandler annotationDeploymentHandler() {
        DeploymentStrategy deployment = (DeploymentStrategy)Component.getInstance((String)"deploymentStrategy");
        if (deployment != null) {
            return (AnnotationDeploymentHandler)deployment.getDeploymentHandlers().get("org.jboss.seam.deployment.AnnotationDeploymentHandler");
        }
        return null;
    }

    private Collection<Class<?>> scannedClasses() {
        Collection result = null;
        AnnotationDeploymentHandler handler = this.annotationDeploymentHandler();
        if (handler != null) {
            result = (Collection)handler.getClassMap().get(FlexRemote.class.getName());
        }
        return result != null ? result : new ArrayList(0);
    }

    @Create
    public void seamInit() {
        this.scanned.addAll(this.scannedClasses());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.messageBrokerManager = new MessageBrokerManager();
        this.messageBrokerManager.init(new FlexServletConfig(filterConfig.getServletContext()));
        this.messageBrokerManager.addDestinations(this.scanned);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isMappedToCurrentRequestPath(request)) {
            this.messageBrokerManager.service((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private static class FlexServletConfig
    implements ServletConfig {
        Map<String, String> params;
        ServletContext context;

        public FlexServletConfig(ServletContext context) {
            this(context, null);
        }

        public FlexServletConfig(ServletContext context, Map<String, String> params) {
            this.context = context;
            this.params = params != null ? params : new HashMap();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getServletName() {
            return "FlexServlet";
        }

        public String getInitParameter(String param) {
            String result = this.params.get(param);
            log.info((Object)("init param " + param + " is " + result));
            return result;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.params.keySet());
        }
    }
}

