/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.text.MessageFormat;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.richfaces.application.push.MessageDataSerializer;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionPreSubscriptionEvent;
import org.richfaces.application.push.SessionTopicListener;
import org.richfaces.application.push.SubscriptionFailureException;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicEvent;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicListener;
import org.richfaces.application.push.impl.DefaultMessageDataSerializer;
import org.richfaces.application.push.impl.SessionTopicListenerWrapper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public abstract class AbstractTopic
implements Topic {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private TopicKey key;
    private volatile MessageDataSerializer serializer;
    private volatile boolean allowSubtopics;
    private List<TopicListener> listeners = new CopyOnWriteArrayList<TopicListener>();

    public AbstractTopic(TopicKey key) {
        this.key = key;
    }

    public MessageDataSerializer getMessageDataSerializer() {
        if (this.serializer == null) {
            return DefaultMessageDataSerializer.instance();
        }
        return this.serializer;
    }

    public void setMessageDataSerializer(MessageDataSerializer serializer) {
        this.serializer = serializer;
    }

    public boolean isAllowSubtopics() {
        return this.allowSubtopics;
    }

    public void setAllowSubtopics(boolean allowSubtopics) {
        this.allowSubtopics = allowSubtopics;
    }

    public TopicKey getKey() {
        return this.key;
    }

    public void addTopicListener(TopicListener topicListener) {
        Object listener = topicListener;
        if (listener instanceof SessionTopicListener) {
            listener = new SessionTopicListenerWrapper((SessionTopicListener)listener);
        }
        this.listeners.add((TopicListener)listener);
    }

    public void removeTopicListener(TopicListener topicListener) {
        if (topicListener instanceof SessionTopicListener) {
            Iterator<TopicListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                SessionTopicListenerWrapper listenerWrapper;
                TopicListener next = iterator.next();
                if (!(next instanceof SessionTopicListenerWrapper) || !topicListener.equals((listenerWrapper = (SessionTopicListenerWrapper)next).getWrappedListener())) continue;
                iterator.remove();
                break;
            }
        } else {
            this.listeners.remove(topicListener);
        }
    }

    public void checkSubscription(TopicKey key, Session session) throws SubscriptionFailureException {
        SessionPreSubscriptionEvent event = new SessionPreSubscriptionEvent((Topic)this, key, session);
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener((EventListener)listener)) continue;
            try {
                event.invokeListener((EventListener)listener);
            }
            catch (SubscriptionFailureException e) {
                throw e;
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    private void logError(Exception e) {
        LOGGER.error((CharSequence)MessageFormat.format("Exception invoking listener: {0}", e.getMessage()), (Throwable)e);
    }

    public void publishEvent(TopicEvent event) {
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener((EventListener)listener)) continue;
            try {
                event.invokeListener((EventListener)listener);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    public abstract void publish(TopicKey var1, Object var2) throws MessageException;
}

