/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.websocket.WebSocket;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.impl.MessageDataScriptString;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class RequestImpl
implements Request,
AtmosphereResourceEventListener {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final int SUSPEND_TIMEOUT = 30000;
    private Session session;
    private final Meteor meteor;
    private AtomicBoolean hasActiveBroadcaster = new AtomicBoolean(false);
    private BroadcasterLifeCyclePolicy policy;

    public RequestImpl(Meteor meteor, Session session) {
        this.meteor = meteor;
        meteor.addListener((AtmosphereResourceEventListener)this);
        this.session = session;
        this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        this.meteor.getBroadcaster().setBroadcasterLifeCyclePolicy(this.policy);
    }

    public void suspend() {
        this.meteor.suspend(30000L, this.isPolling());
    }

    public void resume() {
        this.meteor.resume();
    }

    public boolean isPolling() {
        AtmosphereRequest req = this.meteor.getAtmosphereResource().getRequest();
        boolean isWebsocket = req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) != null || req.getAttribute(WebSocket.WEBSOCKET_RESUME) != null;
        return !isWebsocket;
    }

    public Session getSession() {
        return this.session;
    }

    public void postMessages() {
        if (!this.session.getMessages().isEmpty() && this.lockBroadcaster()) {
            if (!this.session.getMessages().isEmpty()) {
                this.meteor.getBroadcaster().broadcast((Object)new MessageDataScriptString(this.getSession().getMessages()));
            } else {
                this.unlockBroadcaster();
                this.postMessages();
            }
        }
    }

    public void onSuspend(AtmosphereResourceEvent event) {
        try {
            this.getSession().connect((Request)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disconnect() {
        try {
            this.getSession().disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume(AtmosphereResourceEvent event) {
        this.disconnect();
    }

    public void onDisconnect(AtmosphereResourceEvent event) {
        this.disconnect();
    }

    public void onBroadcast(AtmosphereResourceEvent event) {
        MessageDataScriptString serializedMessages = (MessageDataScriptString)((Object)event.getMessage());
        this.getSession().clearBroadcastedMessages(serializedMessages.getLastSequenceNumber());
        this.unlockBroadcaster();
        if (this.isPolling()) {
            event.getResource().resume();
        } else {
            this.postMessages();
        }
    }

    public void onThrowable(AtmosphereResourceEvent event) {
        Throwable throwable = event.throwable();
        LOGGER.error((CharSequence)throwable.getMessage(), throwable);
    }

    private boolean lockBroadcaster() {
        return this.hasActiveBroadcaster.compareAndSet(false, true);
    }

    private void unlockBroadcaster() {
        boolean previousValue = this.hasActiveBroadcaster.getAndSet(false);
        if (!previousValue) {
            throw new IllegalStateException("Request should be blocked in time of broadcasting");
        }
    }
}

