/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;

final class NamingContainerVisitContext
extends ExtendedVisitContext {
    private Set<String> ids;
    private IdsProxyCollection idsToVisit;
    private UIComponent startingComponent;

    public NamingContainerVisitContext(FacesContext facesContext, ExtendedVisitContextMode visitMode, UIComponent component, Collection<String> ids) {
        super(facesContext, visitMode);
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        this.ids = new HashSet<String>(ids);
        this.idsToVisit = new IdsProxyCollection();
        this.startingComponent = component;
    }

    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        VisitResult result = VisitResult.ACCEPT;
        String id = this.buildExtendedComponentId(component);
        if (this.ids.contains(id)) {
            result = callback.visit((VisitContext)this, component);
            this.ids.remove(id);
            if (this.ids.isEmpty()) {
                return VisitResult.COMPLETE;
            }
        }
        if (component instanceof NamingContainer && !component.equals(this.startingComponent)) {
            return VisitResult.REJECT;
        }
        return result;
    }

    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException(component.toString());
        }
        if (this.startingComponent.equals(component)) {
            return VisitContext.ALL_IDS;
        }
        return Collections.emptySet();
    }

    public Collection<String> getDirectSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException(component.toString());
        }
        if (this.startingComponent.equals(component)) {
            return Collections.unmodifiableCollection(this.ids);
        }
        return Collections.emptySet();
    }

    public Set<VisitHint> getHints() {
        return Collections.emptySet();
    }

    public Collection<String> getIdsToVisit() {
        return this.idsToVisit;
    }

    public VisitContext createNamingContainerVisitContext(UIComponent component, Collection<String> directIds) {
        return new NamingContainerVisitContext(this.getFacesContext(), this.getVisitMode(), component, directIds);
    }

    private final class IdsProxyCollection
    extends AbstractCollection<String> {
        private IdsProxyCollection() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException("iterator() method is not supported by this collection implementation");
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("size() method is not supported by this collection implementation");
        }

        @Override
        public boolean isEmpty() {
            return NamingContainerVisitContext.this.ids.isEmpty();
        }
    }
}

