/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.html.ResourceRenderer;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;
import org.richfaces.resource.ResourceLibraryFactory;
import org.richfaces.util.FastJoiner;

public class ResourceLibraryRenderer
extends ResourceRenderer {
    public static final String RENDERER_TYPE = "org.richfaces.renderkit.ResourceLibraryRenderer";
    public static final String RESOURCE_LIBRARY_EXTENSION = ".reslib";
    private static final Logger LOGGER = RichfacesLogger.RENDERKIT.getLogger();
    private static final FastJoiner COLON_JOINER = FastJoiner.on((char)':');

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        if (!name.endsWith(RESOURCE_LIBRARY_EXTENSION)) {
            throw new IllegalArgumentException("Resource library name: " + name + " is incorrect");
        }
        name = name.substring(0, name.length() - RESOURCE_LIBRARY_EXTENSION.length());
        String library = (String)attributes.get("library");
        ResourceLibraryFactory factory = (ResourceLibraryFactory)ServiceTracker.getService(ResourceLibraryFactory.class);
        ResourceLibrary resourceLibrary = factory.getResourceLibrary(name, library);
        if (resourceLibrary == null) {
            LOGGER.error((CharSequence)("Resource library is null: " + COLON_JOINER.join(library, name)));
            return;
        }
        for (ResourceKey resourceKey : resourceLibrary.getResources()) {
            this.encodeResource(component, context, resourceKey);
        }
    }
}

