/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.richfaces.application.Initializable;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceMappingFeature;
import org.richfaces.resource.external.ExternalMapping;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalStaticResourceFactory;
import org.richfaces.util.PropertiesUtil;

public class ExternalStaticResourceFactoryImpl
implements ExternalStaticResourceFactory,
Initializable {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private Map<ResourceKey, ExternalMapping> externalStaticResources;

    public void init() {
        HashMap result = Maps.newHashMap();
        List<String> mappingFiles = ResourceMappingFeature.getMappingFiles();
        for (String mappingFile : mappingFiles) {
            if (this.classpathResourceExistsForLocation(mappingFile)) {
                for (Map.Entry<String, String> entry : PropertiesUtil.loadProperties(mappingFile).entrySet()) {
                    ResourceKey resourceKey = ResourceKey.create((String)entry.getKey());
                    String resourceLocation = entry.getValue();
                    result.put(resourceKey, new ExternalMapping(resourceKey, resourceLocation));
                }
                continue;
            }
            if (this.isDefaultStaticResourceMappingLocation(mappingFile)) continue;
            LOGGER.warn((CharSequence)("Resource mapping is configured to load non-existent resource: '" + mappingFile + "'"));
        }
        this.externalStaticResources = result;
    }

    public ExternalResource createResource(FacesContext facesContext, ResourceKey resourceKey) {
        ExternalMapping mapping = this.externalStaticResources.get(resourceKey);
        if (mapping == null) {
            return null;
        }
        return mapping.getResource(facesContext);
    }

    public Set<ResourceKey> getResourcesForLocation(String resourceLocation) {
        if (this.externalStaticResources == null) {
            LOGGER.error((CharSequence)"factory hasn't been initialized yet");
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (Map.Entry<ResourceKey, ExternalMapping> entry : this.externalStaticResources.entrySet()) {
            ResourceKey resourceKey = entry.getKey();
            ExternalMapping mapping = entry.getValue();
            if (!mapping.getResourceLocation().equals(resourceLocation)) continue;
            result.add(resourceKey);
        }
        return result;
    }

    public void release() {
        this.externalStaticResources.clear();
        this.externalStaticResources = null;
    }

    private boolean classpathResourceExistsForLocation(String location) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader.getResource(location) != null;
    }

    private boolean isDefaultStaticResourceMappingLocation(String location) {
        return "META-INF/richfaces/static-resource-mappings.properties".equals(location);
    }
}

