/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.webapp.PushServlet;

public class PushFilter
implements Filter {
    private static final long serialVersionUID = 7616370505508715222L;
    private static final Logger LOGGER = RichfacesLogger.WEBAPP.getLogger();
    private PushServlet pushServlet;
    private ServletConfigFacade servletConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logPushFilterWarning(filterConfig.getServletContext());
        this.servletConfig = new ServletConfigFacade(filterConfig);
    }

    private void logPushFilterWarning(ServletContext servletContext) {
        String message = servletContext.getMajorVersion() >= 3 ? "PushFilter has been deprecated, you can remove its declaration in Servlets 3 environment" : "PushFilter has been deprecated, you should use PushServlet instead";
        LOGGER.warn((CharSequence)message);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            HttpServletResponse httpResp = (HttpServletResponse)response;
            if ("GET".equals(httpReq.getMethod()) && httpReq.getQueryString() != null && httpReq.getQueryString().contains("__richfacesPushAsync")) {
                if (this.pushServlet == null) {
                    this.pushServlet = new PushServlet();
                    this.pushServlet.init(this.servletConfig);
                }
                this.pushServlet.doGet(httpReq, httpResp);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        if (this.pushServlet != null) {
            this.pushServlet.destroy();
            this.pushServlet = null;
        }
    }

    private final class ServletConfigFacade
    implements ServletConfig {
        private final FilterConfig filterConfig;

        private ServletConfigFacade(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public String getServletName() {
            return this.filterConfig.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.filterConfig.getServletContext();
        }

        public String getInitParameter(String name) {
            String result = this.filterConfig.getInitParameter(name);
            if (result == null) {
                result = this.filterConfig.getServletContext().getInitParameter(name);
            }
            return result;
        }

        public Enumeration<String> getInitParameterNames() {
            LinkedHashSet result = Sets.newLinkedHashSet();
            result.addAll(Collections.list(this.filterConfig.getInitParameterNames()));
            result.addAll(Collections.list(this.filterConfig.getServletContext().getInitParameterNames()));
            return Iterators.asEnumeration(result.iterator());
        }
    }
}

