/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public final class ContainerStateMonitor
extends AbstractServiceListener<Object> {
    private final ServiceRegistry serviceRegistry;
    private final ServiceController<?> controllerController;
    private final AtomicInteger busyServiceCount = new AtomicInteger();
    private final Map<ServiceController<?>, String> failedControllers = new IdentityHashMap();
    private final Set<ServiceController<?>> servicesWithMissingDeps = ContainerStateMonitor.identitySet();
    private Set<ServiceName> previousMissingDepSet = new HashSet<ServiceName>();
    private ContainerStateChangeReport changeReport;

    ContainerStateMonitor(ServiceRegistry registry, ServiceController<?> controller) {
        this.serviceRegistry = registry;
        this.controllerController = controller;
    }

    void acquire() {
        this.untick();
    }

    void release() {
        this.tick();
    }

    public void listenerAdded(ServiceController<?> controller) {
        if (controller == this.controllerController) {
            controller.removeListener((ServiceListener)this);
        } else {
            this.untick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_START_FAILED: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.put(controller, controller.getStartException().toString());
                    break;
                }
            }
            case REMOVING_to_REMOVED: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.remove(controller);
                    this.servicesWithMissingDeps.remove(controller);
                    break;
                }
            }
            case START_FAILED_to_DOWN: 
            case START_FAILED_to_STARTING: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.remove(controller);
                    break;
                }
            }
        }
        ServiceController.Substate before = transition.getBefore();
        ServiceController.Substate after = transition.getAfter();
        if (before.isRestState() && !after.isRestState()) {
            this.untick();
        } else if (!before.isRestState() && after.isRestState()) {
            this.tick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateDependencyAvailable(ServiceController<?> controller) {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            this.servicesWithMissingDeps.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateDependencyUnavailable(ServiceController<?> controller) {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            this.servicesWithMissingDeps.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitUninterruptibly(int count) {
        boolean intr = false;
        try {
            ContainerStateMonitor containerStateMonitor = this;
            synchronized (containerStateMonitor) {
                while (this.busyServiceCount.get() > count) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void await(int count) throws InterruptedException {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            while (this.busyServiceCount.get() > count) {
                ((Object)((Object)this)).wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerStateChangeReport awaitContainerStateChangeReport(int count) throws InterruptedException {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            while (this.busyServiceCount.get() > count) {
                ((Object)((Object)this)).wait();
            }
            this.changeReport = this.createContainerStateChangeReport();
            return this.changeReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        int tick = this.busyServiceCount.decrementAndGet();
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            ((Object)((Object)this)).notifyAll();
            if (tick == 0) {
                if (this.changeReport == null) {
                    this.changeReport = this.createContainerStateChangeReport();
                }
                if (this.changeReport != null) {
                    String msg = this.createChangeReportLogMessage(this.changeReport);
                    this.changeReport = null;
                    ControllerLogger.ROOT_LOGGER.info(msg);
                }
            }
        }
    }

    private void untick() {
        this.busyServiceCount.incrementAndGet();
    }

    private synchronized ContainerStateChangeReport createContainerStateChangeReport() {
        HashMap<ServiceName, HashSet<ServiceName>> missingDeps = new HashMap<ServiceName, HashSet<ServiceName>>();
        for (ServiceController<?> controller : this.servicesWithMissingDeps) {
            for (ServiceName missing : controller.getImmediateUnavailableDependencies()) {
                HashSet<ServiceName> dependents = (HashSet<ServiceName>)missingDeps.get(missing);
                if (dependents == null) {
                    dependents = new HashSet<ServiceName>();
                    missingDeps.put(missing, dependents);
                }
                dependents.add(controller.getName());
            }
        }
        Set<ServiceName> previousMissing = this.previousMissingDepSet;
        TreeMap<ServiceName, Boolean> noLongerMissingServices = new TreeMap<ServiceName, Boolean>();
        for (ServiceName name : previousMissing) {
            if (missingDeps.containsKey(name)) continue;
            ServiceController controller = this.serviceRegistry.getService(name);
            noLongerMissingServices.put(name, controller == null);
        }
        TreeMap<ServiceName, MissingDependencyInfo> missingServices = new TreeMap<ServiceName, MissingDependencyInfo>();
        for (Map.Entry entry : missingDeps.entrySet()) {
            ServiceName name = (ServiceName)entry.getKey();
            if (previousMissing.contains(name)) continue;
            ServiceController controller = this.serviceRegistry.getService(name);
            boolean unavailable = controller != null;
            missingServices.put(name, new MissingDependencyInfo(name, unavailable, (Set)entry.getValue()));
        }
        HashMap currentFailedControllers = new HashMap(this.failedControllers);
        this.previousMissingDepSet = new HashSet(missingDeps.keySet());
        this.failedControllers.clear();
        boolean needReport = !missingServices.isEmpty() || !currentFailedControllers.isEmpty() || !noLongerMissingServices.isEmpty();
        return needReport ? new ContainerStateChangeReport(missingServices, currentFailedControllers, noLongerMissingServices) : null;
    }

    private synchronized String createChangeReportLogMessage(ContainerStateChangeReport changeReport) {
        StringBuilder msg = new StringBuilder();
        msg.append(ControllerMessages.MESSAGES.serviceStatusReportHeader());
        if (!changeReport.getMissingServices().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportDependencies());
            for (Map.Entry<ServiceName, MissingDependencyInfo> entry : changeReport.getMissingServices().entrySet()) {
                if (!entry.getValue().isUnavailable()) {
                    msg.append(ControllerMessages.MESSAGES.serviceStatusReportMissing(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
                    continue;
                }
                msg.append(ControllerMessages.MESSAGES.serviceStatusReportUnavailable(entry.getKey(), ContainerStateMonitor.createDependentsString(entry.getValue().getDependents())));
            }
        }
        if (!changeReport.getNoLongerMissingServices().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportCorrected());
            for (Map.Entry<ServiceName, Object> entry : changeReport.getNoLongerMissingServices().entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) {
                    msg.append(ControllerMessages.MESSAGES.serviceStatusReportNoLongerRequired(entry.getKey()));
                    continue;
                }
                msg.append(ControllerMessages.MESSAGES.serviceStatusReportAvailable(entry.getKey()));
            }
        }
        if (!changeReport.getFailedControllers().isEmpty()) {
            msg.append(ControllerMessages.MESSAGES.serviceStatusReportFailed());
            for (Map.Entry<ServiceName, Object> entry : changeReport.getFailedControllers().entrySet()) {
                msg.append("      ").append(((ServiceController)entry.getKey()).getName()).append(": ").append((String)entry.getValue()).append('\n');
            }
        }
        return msg.toString();
    }

    private static String createDependentsString(Set<ServiceName> serviceNames) {
        if (serviceNames.size() <= 4) {
            return serviceNames.toString();
        }
        StringBuilder ret = new StringBuilder("[");
        Iterator<ServiceName> it = serviceNames.iterator();
        for (int count = 0; count < 4; ++count) {
            ServiceName val = it.next();
            ret.append(val);
            ret.append(", ");
        }
        ret.append(ControllerMessages.MESSAGES.andNMore(serviceNames.size() - 3));
        ret.append(" ]");
        return ret.toString();
    }

    private static <T> Set<T> identitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public static class MissingDependencyInfo {
        private final ServiceName serviceName;
        private final boolean unavailable;
        private final Set<ServiceName> dependents;

        public MissingDependencyInfo(ServiceName serviceName, boolean unavailable, Set<ServiceName> dependents) {
            this.serviceName = serviceName;
            this.unavailable = unavailable;
            this.dependents = dependents;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        public Set<ServiceName> getDependents() {
            return Collections.unmodifiableSet(this.dependents);
        }
    }

    public static class ContainerStateChangeReport {
        private final Map<ServiceName, MissingDependencyInfo> missingServices;
        private final Map<ServiceController<?>, String> failedControllers;
        private final Map<ServiceName, Boolean> noLongerMissingServices;

        private ContainerStateChangeReport(Map<ServiceName, MissingDependencyInfo> missingServices, Map<ServiceController<?>, String> failedControllers, Map<ServiceName, Boolean> noLongerMissingServices) {
            this.missingServices = missingServices;
            this.failedControllers = failedControllers;
            this.noLongerMissingServices = noLongerMissingServices;
        }

        public final Map<ServiceController<?>, String> getFailedControllers() {
            return this.failedControllers;
        }

        public Map<ServiceName, MissingDependencyInfo> getMissingServices() {
            return this.missingServices;
        }

        public Map<ServiceName, Boolean> getNoLongerMissingServices() {
            return this.noLongerMissingServices;
        }
    }
}

