/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public final class ServiceVerificationHandler
extends AbstractServiceListener<Object>
implements ServiceListener<Object>,
OperationStepHandler {
    private final Set<ServiceController<?>> set = new HashSet();
    private final Set<ServiceController<?>> failed = new HashSet();
    private final Set<ServiceController<?>> problem = new HashSet();
    private int outstanding;

    @Override
    public synchronized void execute(OperationContext context, ModelNode operation) {
        long start = 0L;
        long settleTime = 100L;
        while (this.outstanding > 0 || settleTime > 0L && !this.problem.isEmpty()) {
            try {
                long wait = this.outstanding > 0 ? 0L : settleTime;
                this.wait(wait);
                if (this.outstanding == 0) {
                    if (start == 0L) {
                        start = System.currentTimeMillis();
                        continue;
                    }
                    settleTime -= System.currentTimeMillis() - start;
                    continue;
                }
                start = 0L;
                settleTime = 100L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                context.getFailureDescription().set(ControllerMessages.MESSAGES.operationCancelled());
                context.completeStep();
                return;
            }
        }
        if (!this.failed.isEmpty() || !this.problem.isEmpty()) {
            ModelNode failureDescription = context.getFailureDescription();
            ModelNode failedList = null;
            for (ServiceController<?> controller : this.failed) {
                if (failedList == null) {
                    failedList = failureDescription.get(ControllerMessages.MESSAGES.failedServices());
                }
                failedList.get(controller.getName().getCanonicalName()).set(controller.getStartException().toString());
            }
            ModelNode problemList = null;
            for (ServiceController<?> controller : this.problem) {
                if (controller.getImmediateUnavailableDependencies().isEmpty()) continue;
                if (problemList == null) {
                    problemList = failureDescription.get(ControllerMessages.MESSAGES.servicesMissingDependencies());
                }
                StringBuilder problem = new StringBuilder();
                problem.append(controller.getName().getCanonicalName());
                Iterator i = controller.getImmediateUnavailableDependencies().iterator();
                while (i.hasNext()) {
                    ServiceName missing = (ServiceName)i.next();
                    problem.append(missing.getCanonicalName());
                    if (!i.hasNext()) continue;
                    problem.append(", ");
                }
                problem.append(ControllerMessages.MESSAGES.servicesMissing(problem));
                problemList.add(problem.toString());
            }
            if (context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
        }
        for (ServiceController<?> controller : this.set) {
            controller.removeListener((ServiceListener)this);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public synchronized void listenerAdded(ServiceController<?> controller) {
        this.set.add(controller);
        if (!controller.getSubstate().isRestState()) {
            ++this.outstanding;
        }
    }

    public synchronized void transition(ServiceController<?> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_START_FAILED: {
                this.failed.add(controller);
                break;
            }
            case START_FAILED_to_STARTING: {
                this.failed.remove(controller);
                break;
            }
            case START_REQUESTED_to_PROBLEM: {
                this.problem.add(controller);
                break;
            }
            case PROBLEM_to_START_REQUESTED: {
                this.problem.remove(controller);
            }
        }
        if (transition.leavesRestState()) {
            ++this.outstanding;
        } else if (transition.entersRestState() && this.outstanding-- == 1) {
            this.notifyAll();
        }
    }
}

