/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class PathAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final PathAddHandler NAMED_INSTANCE = new PathAddHandler(false, false);
    public static final PathAddHandler SPECIFIED_INSTANCE = new PathAddHandler(true, true);
    public static final PathAddHandler SPECIFIED_NO_SERVICES_INSTANCE = new PathAddHandler(true, false);
    private final boolean specified;
    private final boolean services;
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getAddPathOperation(ModelNode address, ModelNode path, ModelNode relativeTo) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        if (path.isDefined()) {
            op.get("path").set(path);
        }
        if (relativeTo.isDefined()) {
            op.get("relative-to").set(relativeTo);
        }
        return op;
    }

    protected PathAddHandler(boolean specified, boolean services) {
        this.specified = specified;
        this.services = services;
        this.validator.registerValidator("path", new StringLengthValidator(1, !specified));
        this.validator.registerValidator("relative-to", new ModelTypeValidator(ModelType.STRING, true));
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        model.get("path").set(operation.get("path"));
        model.get("relative-to").set(operation.get("relative-to"));
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return this.services;
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode pathNode = operation.get("path");
        ModelNode relNode = operation.get("relative-to");
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        String relativeTo = relNode.isDefined() ? relNode.asString() : null;
        ServiceTarget target = context.getServiceTarget();
        if (relativeTo == null) {
            newControllers.add(AbsolutePathService.addService(name, path, target, newControllers, verificationHandler));
        } else {
            newControllers.add(RelativePathService.addService(name, path, relativeTo, target, newControllers, verificationHandler));
        }
    }

    @Override
    protected boolean requiresRuntimeVerification() {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.specified ? PathDescription.getSpecifiedPathAddOperation(locale) : PathDescription.getNamedPathAddOperation(locale);
    }
}

