/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.dmr.ModelNode;

public class FilePersistenceResource
implements ConfigurationPersister.PersistenceResource {
    private ExposedByteArrayOutputStream marshalled;
    private final File fileName;
    private final AbstractConfigurationPersister persister;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilePersistenceResource(ModelNode model, File fileName, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        this.fileName = fileName;
        this.persister = persister;
        this.marshalled = new ExposedByteArrayOutputStream(8192);
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(this.marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                this.marshalled.close();
            }
            finally {
                FilePersistenceResource.safeClose(this.marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToMarshalConfiguration(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.marshalled == null) {
            throw ControllerMessages.MESSAGES.rollbackAlreadyInvoked();
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.fileName);
            ByteArrayInputStream is = this.marshalled.getInputStream();
            try {
                int read;
                BufferedOutputStream output = new BufferedOutputStream(fos);
                byte[] bytes = new byte[1024];
                while ((read = is.read(bytes)) > -1) {
                    output.write(bytes, 0, read);
                }
                output.flush();
                fos.getFD().sync();
                output.close();
                ((InputStream)is).close();
            }
            finally {
                FilePersistenceResource.safeClose(fos);
                FilePersistenceResource.safeClose(is);
            }
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
        }
    }

    @Override
    public void rollback() {
        this.marshalled = null;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }
}

