/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.util.DateConverter;

public class AddMetadataFromDocInfo {
    private static final String PADDING = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ";

    private AddMetadataFromDocInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            AddMetadataFromDocInfo.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Cannot add metadata to encrypted document.");
                    System.exit(1);
                }
                PDDocumentCatalog catalog = document.getDocumentCatalog();
                PDDocumentInformation info = document.getDocumentInformation();
                StringBuffer xmp = new StringBuffer();
                xmp.append("<?xpacket begin='\u00ef\u00bb\u00bf' id='W5M0MpCehiHzreSzNTczkc9d'?>\n<?adobe-xap-filters esc=\"CRLF\"?>\n<x:xmpmeta>\n    <rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n        <rdf:Description rdf:about='' xmlns:pdf='http://ns.adobe.com/pdf/1.3/' pdf:Keywords='" + AddMetadataFromDocInfo.fixNull(info.getKeywords()) + "' " + "pdf:Producer='" + AddMetadataFromDocInfo.fixNull(info.getProducer()) + "'></rdf:Description>\n" + "        <rdf:Description rdf:about='' xmlns:xap='http://ns.adobe.com/xap/1.0/' " + "xap:ModifyDate='" + AddMetadataFromDocInfo.fixNull(info.getModificationDate()) + "' " + "xap:CreateDate='" + AddMetadataFromDocInfo.fixNull(info.getCreationDate()) + "' " + "xap:CreatorTool='" + AddMetadataFromDocInfo.fixNull(info.getCreator()) + "' " + "xap:MetadataDate='" + AddMetadataFromDocInfo.fixNull(new GregorianCalendar()) + "'>\n" + "        </rdf:Description>\n" + "        <rdf:Description rdf:about='' xmlns:dc='http://purl.org/dc/elements/1.1/' " + "dc:format='application/pdf'>\n" + "            <dc:title>\n" + "                <rdf:Alt>\n" + "                    <rdf:li xml:lang='x-default'>" + AddMetadataFromDocInfo.fixNull(info.getTitle()) + "</rdf:li>\n" + "                </rdf:Alt>\n" + "            </dc:title>\n" + "            <dc:creator>\n" + "                <rdf:Seq>\n" + "                    <rdf:li>PDFBox.org</rdf:li>\n" + "                </rdf:Seq>\n" + "            </dc:creator>\n" + "            <dc:description>\n" + "                <rdf:Alt>\n" + "                    <rdf:li xml:lang='x-default'>" + AddMetadataFromDocInfo.fixNull(info.getSubject()) + "</rdf:li>\n" + "                </rdf:Alt>\n" + "            </dc:description>\n" + "        </rdf:Description>\n" + "    </rdf:RDF>\n" + "</x:xmpmeta>\n");
                xmp.append(PADDING);
                xmp.append(PADDING);
                xmp.append(PADDING);
                xmp.append("\n<?xpacket end='w'?>");
                ByteArrayInputStream mdInput = new ByteArrayInputStream(xmp.toString().getBytes());
                PDMetadata metadataStream = new PDMetadata(document, mdInput, false);
                catalog.setMetadata(metadataStream);
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static String fixNull(String string) {
        return string == null ? "" : string;
    }

    private static String fixNull(Calendar cal) {
        return cal == null ? "" : DateConverter.toISO8601(cal);
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.AddMetadata <input-pdf> <output-pdf>");
    }
}

