/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class PushBackInputStream
extends PushbackInputStream {
    public PushBackInputStream(InputStream input, int size) throws IOException {
        super(input, size);
        if (input == null) {
            throw new IOException("Error: input was null");
        }
    }

    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.unread(result);
        }
        return result;
    }

    public boolean isEOF() throws IOException {
        int peek = this.peek();
        return peek == -1;
    }

    public void fillBuffer() throws IOException {
        int bufferLength = this.buf.length;
        byte[] tmpBuffer = new byte[bufferLength];
        int amountRead = 0;
        int totalAmountRead = 0;
        while (amountRead != -1 && totalAmountRead < bufferLength) {
            amountRead = this.read(tmpBuffer, totalAmountRead, bufferLength - totalAmountRead);
            if (amountRead == -1) continue;
            totalAmountRead += amountRead;
        }
        this.unread(tmpBuffer, 0, totalAmountRead);
    }
}

