/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.WrappedIOException;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.pdfparser.BaseParser;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.fdf.FDFDocument;
import org.pdfbox.persistence.util.COSObjectKey;

public class PDFParser
extends BaseParser {
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private COSDocument document;
    private File tempDirectory = null;
    private RandomAccess raf = null;

    public PDFParser(InputStream input) throws IOException {
        this(input, null);
    }

    public PDFParser(InputStream input, RandomAccess rafi) throws IOException {
        super(input);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    public void parse() throws IOException {
        block20: {
            try {
                this.document = this.raf == null ? (this.tempDirectory != null ? new COSDocument(this.tempDirectory) : new COSDocument()) : new COSDocument(this.raf);
                this.setDocument(this.document);
                String header = this.readLine();
                this.document.setHeaderString(header);
                if (header.length() < PDF_HEADER.length() + 1) {
                    throw new IOException("Error: Header is corrupt '" + header + "'");
                }
                int headerStart = header.indexOf(PDF_HEADER);
                if (headerStart > 0) {
                    header = header.substring(headerStart, header.length());
                }
                try {
                    float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                    this.document.setVersion(pdfVersion);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error getting pdf version:" + e);
                }
                this.skipHeaderFillBytes();
                boolean wasLastParsedObjectAnXref = false;
                try {
                    Object nextObject;
                    while ((nextObject = this.parseObject()) != null) {
                        if (nextObject instanceof PDFXref) {
                            PDFXref xref = (PDFXref)nextObject;
                            this.addXref(xref);
                            wasLastParsedObjectAnXref = true;
                        } else {
                            wasLastParsedObjectAnXref = false;
                        }
                        this.skipSpaces();
                    }
                    if (this.document.getTrailer() == null) {
                        COSDictionary trailer = new COSDictionary();
                        Iterator xrefIter = this.document.getObjectsByType("XRef").iterator();
                        while (xrefIter.hasNext()) {
                            COSStream next = (COSStream)((COSObject)xrefIter.next()).getObject();
                            trailer.addAll(next);
                        }
                        this.document.setTrailer(trailer);
                    }
                    if (!this.document.isEncrypted()) {
                        this.document.dereferenceObjectStreams();
                    }
                }
                catch (IOException e) {
                    if (wasLastParsedObjectAnXref) {
                        break block20;
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                if (this.document != null) {
                    this.document.close();
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new WrappedIOException(t);
            }
            finally {
                this.pdfSource.close();
            }
        }
    }

    protected void skipHeaderFillBytes() throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.peek();
        if (!Character.isDigit((char)c)) {
            this.readLine();
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument());
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private Object parseObject() throws IOException {
        Object object = null;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x' || peekedChar == 't' || peekedChar == 's') {
                String eof;
                if (peekedChar == 'x' || peekedChar == 't') {
                    object = this.parseXrefSection();
                }
                if (peekedChar == 'x' || peekedChar == 's') {
                    this.skipSpaces();
                    while (this.pdfSource.peek() == 120) {
                        this.parseXrefSection();
                    }
                    String startxref = this.readString();
                    if (!startxref.equals("startxref")) {
                        throw new IOException("expected='startxref' actual='" + startxref + "' " + this.pdfSource);
                    }
                    this.skipSpaces();
                    this.readInt();
                }
                if ((eof = this.readExpectedString("%%EOF")).indexOf("%%EOF") == -1 && !this.pdfSource.isEOF()) {
                    throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
                }
                if (!this.pdfSource.isEOF()) {
                    this.pdfSource.fillBuffer();
                    if (this.pdfSource.available() < 1000) {
                        byte[] data = new byte[1000];
                        int amountRead = this.pdfSource.read(data);
                        if (amountRead != -1) {
                            this.pdfSource.unread(data, 0, amountRead);
                        }
                        boolean atEndOfFile = true;
                        for (int i = 0; i < amountRead - 3 && atEndOfFile; ++i) {
                            atEndOfFile = data[i] != 69 || data[i + 1] != 79 || data[i + 2] != 70;
                        }
                        if (atEndOfFile) {
                            while (this.pdfSource.read(data, 0, data.length) != -1) {
                            }
                        }
                    }
                }
            } else {
                block28: {
                    int number = -1;
                    int genNum = -1;
                    String objectKey = null;
                    boolean missingObjectNumber = false;
                    try {
                        char peeked = (char)this.pdfSource.peek();
                        if (peeked == '<') {
                            missingObjectNumber = true;
                        } else {
                            number = this.readInt();
                        }
                    }
                    catch (IOException e) {
                        number = this.readInt();
                    }
                    if (!missingObjectNumber) {
                        this.skipSpaces();
                        genNum = this.readInt();
                        objectKey = this.readString(3);
                        if (!objectKey.equals("obj")) {
                            throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                        }
                    } else {
                        number = -1;
                        genNum = -1;
                    }
                    this.skipSpaces();
                    COSBase pb = this.parseDirObject();
                    String endObjectKey = this.readString();
                    if (endObjectKey.equals("stream")) {
                        this.pdfSource.unread(endObjectKey.getBytes());
                        this.pdfSource.unread(32);
                        if (!(pb instanceof COSDictionary)) {
                            throw new IOException("stream not preceded by dictionary");
                        }
                        pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        endObjectKey = this.readString();
                    }
                    COSObjectKey key = new COSObjectKey(number, genNum);
                    COSObject pdfObject = this.document.getObjectFromPool(key);
                    object = pdfObject;
                    pdfObject.setObject(pb);
                    if (!endObjectKey.equals("endobj") && !this.pdfSource.isEOF()) {
                        try {
                            Float.parseFloat(endObjectKey);
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(endObjectKey.getBytes());
                        }
                        catch (NumberFormatException e) {
                            String secondEndObjectKey = this.readString();
                            if (secondEndObjectKey.equals("endobj")) break block28;
                            if (this.isClosing()) {
                                this.pdfSource.read();
                            }
                            this.skipSpaces();
                            String thirdPossibleEndObj = this.readString();
                            if (thirdPossibleEndObj.equals("endobj")) break block28;
                            throw new IOException("expected='endobj' firstReadAttempt='" + endObjectKey + "' " + "secondReadAttempt='" + secondEndObjectKey + "' " + this.pdfSource);
                        }
                    }
                }
                this.skipSpaces();
            }
        }
        return object;
    }

    protected PDFXref parseXrefSection() throws IOException {
        int[] params = new int[2];
        this.parseXrefTable(params);
        this.parseTrailer();
        return new PDFXref(params[0], params[1]);
    }

    protected void parseXrefTable(int[] params) throws IOException {
        String nextLine = null;
        nextLine = this.readLine();
        if (nextLine.equals("xref")) {
            params[0] = this.readInt();
            params[1] = this.readInt();
            nextLine = this.readString();
        }
        this.skipSpaces();
        while (!(nextLine.equals("trailer") || this.pdfSource.isEOF() || this.isEndOfName((char)this.pdfSource.peek()))) {
            nextLine = this.readString();
            this.skipSpaces();
        }
        this.skipSpaces();
    }

    private void parseTrailer() throws IOException {
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        COSDictionary docTrailer = this.document.getTrailer();
        if (docTrailer == null) {
            this.document.setTrailer(parsedTrailer);
        } else {
            docTrailer.addAll(parsedTrailer);
        }
    }
}

