/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThread;
import org.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;

public class PDDocumentCatalog
implements COSObjectable {
    private COSDictionary root;
    private PDDocument document;
    private PDAcroForm acroForm = null;
    public static final String PAGE_MODE_USE_NONE = "UseNone";
    public static final String PAGE_MODE_USE_OUTLINES = "UseOutlines";
    public static final String PAGE_MODE_USE_THUMBS = "UseThumbs";
    public static final String PAGE_MODE_FULL_SCREEN = "FullScreen";
    public static final String PAGE_MODE_USE_OPTIONAL_CONTENT = "UseOC";
    public static final String PAGE_MODE_USE_ATTACHMENTS = "UseAttachments";
    public static final String PAGE_LAYOUT_SINGLE_PAGE = "SinglePage";
    public static final String PAGE_LAYOUT_ONE_COLUMN = "OneColumn";
    public static final String PAGE_LAYOUT_TWO_COLUMN_LEFT = "TwoColumnLeft";
    public static final String PAGE_LAYOUT_TWO_COLUMN_RIGHT = "TwoColumnRight";
    public static final String PAGE_LAYOUT_TWO_PAGE_LEFT = "TwoPageLeft";
    public static final String PAGE_LAYOUT_TWO_PAGE_RIGHT = "TwoPageRight";

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)new COSString("Catalog"));
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, (COSBase)this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    public COSBase getCOSObject() {
        return this.root;
    }

    public COSDictionary getCOSDictionary() {
        return this.root;
    }

    public PDAcroForm getAcroForm() {
        COSDictionary acroFormDic;
        if (this.acroForm == null && (acroFormDic = (COSDictionary)this.root.getDictionaryObject(COSName.ACRO_FORM)) != null) {
            this.acroForm = new PDAcroForm(this.document, acroFormDic);
        }
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm acro) {
        this.root.setItem(COSName.ACRO_FORM, (COSObjectable)acro);
    }

    public PDPageNode getPages() {
        return new PDPageNode((COSDictionary)this.root.getDictionaryObject(COSName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        PDPageNode rootNode = this.getPages();
        rootNode.getAllKids(retval);
        return retval;
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("ViewerPreferences");
        if (dict != null) {
            retval = new PDViewerPreferences(dict);
        }
        return retval;
    }

    public void setViewerPreferences(PDViewerPreferences prefs) {
        this.root.setItem("ViewerPreferences", (COSObjectable)prefs);
    }

    public PDDocumentOutline getDocumentOutline() {
        PDDocumentOutline retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("Outlines");
        if (dict != null) {
            retval = new PDDocumentOutline(dict);
        }
        return retval;
    }

    public void setDocumentOutline(PDDocumentOutline outlines) {
        this.root.setItem("Outlines", (COSObjectable)outlines);
    }

    public List getThreads() {
        COSArray array = (COSArray)this.root.getDictionaryObject("Threads");
        if (array == null) {
            array = new COSArray();
            this.root.setItem("Threads", (COSBase)array);
        }
        ArrayList<PDThread> pdObjects = new ArrayList<PDThread>();
        for (int i = 0; i < array.size(); ++i) {
            pdObjects.add(new PDThread((COSDictionary)array.getObject(i)));
        }
        return new COSArrayList(pdObjects, array);
    }

    public void setThreads(List threads) {
        this.root.setItem("Threads", (COSBase)COSArrayList.converterToCOSArray(threads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.root.getDictionaryObject("Metadata");
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.root.setItem("Metadata", (COSObjectable)meta);
    }

    public void setOpenAction(PDDestinationOrAction action) {
        this.root.setItem(COSName.getPDFName("OpenAction"), (COSObjectable)action);
    }

    public PDDestinationOrAction getOpenAction() throws IOException {
        PDDestinationOrAction action = null;
        COSBase actionObj = this.root.getDictionaryObject("OpenAction");
        if (actionObj != null) {
            if (actionObj instanceof COSDictionary) {
                action = PDActionFactory.createAction((COSDictionary)actionObj);
            } else if (actionObj instanceof COSArray) {
                action = PDDestination.create(actionObj);
            } else {
                throw new IOException("Unknown OpenAction " + actionObj);
            }
        }
        return action;
    }

    public PDDocumentCatalogAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.root.getDictionaryObject("AA");
        if (addAct == null) {
            addAct = new COSDictionary();
            this.root.setItem("AA", (COSBase)addAct);
        }
        return new PDDocumentCatalogAdditionalActions(addAct);
    }

    public void setActions(PDDocumentCatalogAdditionalActions actions) {
        this.root.setItem("AA", (COSObjectable)actions);
    }

    public PDDocumentNameDictionary getNames() {
        PDDocumentNameDictionary nameDic = null;
        COSDictionary names = (COSDictionary)this.root.getDictionaryObject("Names");
        if (names != null) {
            nameDic = new PDDocumentNameDictionary(this, names);
        }
        return nameDic;
    }

    public void setNames(PDDocumentNameDictionary names) {
        this.root.setItem("Names", (COSObjectable)names);
    }

    public PDMarkInfo getMarkInfo() {
        PDMarkInfo retval = null;
        COSDictionary dic = (COSDictionary)this.root.getDictionaryObject("MarkInfo");
        if (dic != null) {
            retval = new PDMarkInfo(dic);
        }
        return retval;
    }

    public void setMarkInfo(PDMarkInfo markInfo) {
        this.root.setItem("MarkInfo", (COSObjectable)markInfo);
    }

    public String getPageMode() {
        return this.root.getNameAsString("PageMode", PAGE_MODE_USE_NONE);
    }

    public void setPageMode(String mode) {
        this.root.setName("PageMode", mode);
    }

    public String getPageLayout() {
        return this.root.getNameAsString("PageLayout", PAGE_LAYOUT_SINGLE_PAGE);
    }

    public void setPageLayout(String layout) {
        this.root.setName("PageLayout", layout);
    }

    public PDActionURI getURI() {
        PDActionURI retval = null;
        COSDictionary uri = (COSDictionary)this.root.getDictionaryObject("URI");
        if (uri != null) {
            retval = new PDActionURI(uri);
        }
        return retval;
    }

    public void setURI(PDActionURI uri) {
        this.root.setItem("URI", (COSObjectable)uri);
    }

    public PDStructureTreeRoot getStructureTreeRoot() {
        PDStructureTreeRoot treeRoot = null;
        COSDictionary dic = (COSDictionary)this.root.getDictionaryObject("StructTreeRoot");
        if (dic != null) {
            treeRoot = new PDStructureTreeRoot(dic);
        }
        return treeRoot;
    }

    public void setStructureTreeRoot(PDStructureTreeRoot treeRoot) {
        this.root.setItem("StructTreeRoot", (COSObjectable)treeRoot);
    }

    public String getLanguage() {
        return this.root.getString("Lang");
    }

    public void setLanguage(String language) {
        this.root.setString("Lang", language);
    }
}

