/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common.filespecification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.PDStream;

public class PDEmbeddedFile
extends PDStream {
    public PDEmbeddedFile(PDDocument document) {
        super(document);
        this.getStream().setName("Type", "EmbeddedFile");
    }

    public PDEmbeddedFile(COSStream str) {
        super(str);
    }

    public PDEmbeddedFile(PDDocument doc, InputStream str) throws IOException {
        super(doc, str);
        this.getStream().setName("Type", "EmbeddedFile");
    }

    public PDEmbeddedFile(PDDocument doc, InputStream str, boolean filtered) throws IOException {
        super(doc, str, filtered);
        this.getStream().setName("Type", "EmbeddedFile");
    }

    public void setSubtype(String mimeType) {
        this.getStream().setName("Subtype", mimeType);
    }

    public String getSubtype() {
        return this.getStream().getNameAsString("Subtype");
    }

    public int getSize() {
        return this.getStream().getEmbeddedInt("Params", "Size");
    }

    public void setSize(int size) {
        this.getStream().setEmbeddedInt("Params", "Size", size);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getStream().getEmbeddedDate("Params", "CreationDate");
    }

    public void setCreationDate(Calendar creation) {
        this.getStream().setEmbeddedDate("Params", "CreationDate", creation);
    }

    public Calendar getModDate() throws IOException {
        return this.getStream().getEmbeddedDate("Params", "ModDate");
    }

    public void setModDate(Calendar mod) {
        this.getStream().setEmbeddedDate("Params", "ModDate", mod);
    }

    public String getCheckSum() {
        return this.getStream().getEmbeddedString("Params", "CheckSum");
    }

    public void setCheckSum(String checksum) {
        this.getStream().setEmbeddedString("Params", "CheckSum", checksum);
    }

    public String getMacSubtype() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Subtype");
        }
        return retval;
    }

    public void setMacSubtype(String macSubtype) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params == null && macSubtype != null) {
            params = new COSDictionary();
            this.getStream().setItem("Params", (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Subtype", macSubtype);
        }
    }

    public String getMacCreator() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Creator");
        }
        return retval;
    }

    public void setMacCreator(String macCreator) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params == null && macCreator != null) {
            params = new COSDictionary();
            this.getStream().setItem("Params", (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Creator", macCreator);
        }
    }

    public String getMacResFork() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "ResFork");
        }
        return retval;
    }

    public void setMacResFork(String macResFork) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject("Params");
        if (params == null && macResFork != null) {
            params = new COSDictionary();
            this.getStream().setItem("Params", (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "ResFork", macResFork);
        }
    }
}

