/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.IterationStateHolder;

public final class SavedState
implements StateHolder {
    public static final SavedState EMPTY = new SavedState();
    private static final long serialVersionUID = -1563864456074187422L;
    private boolean valid = true;
    private boolean localValueSet;
    private boolean submitted;
    private Object submittedValue;
    private Object value;
    private Object iterationState;

    public SavedState() {
    }

    public SavedState(EditableValueHolder evh) {
        this.value = evh.getLocalValue();
        this.valid = evh.isValid();
        this.submittedValue = evh.getSubmittedValue();
        this.localValueSet = evh.isLocalValueSet();
    }

    public SavedState(IterationStateHolder ish) {
        this.iterationState = ish.getIterationState();
    }

    public SavedState(UIForm form) {
        this.submitted = form.isSubmitted();
    }

    Object getSubmittedValue() {
        return this.submittedValue;
    }

    void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    boolean isLocalValueSet() {
        return this.localValueSet;
    }

    void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    Object getIterationState() {
        return this.iterationState;
    }

    void setIterationState(Object iterationState) {
        this.iterationState = iterationState;
    }

    boolean isSubmitted() {
        return this.submitted;
    }

    void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public String toString() {
        if (this.iterationState != null) {
            return "iterationState: " + this.iterationState;
        }
        return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet + " submitted: " + this.submitted;
    }

    public void apply(EditableValueHolder evh) {
        evh.setValue(this.value);
        evh.setValid(this.valid);
        evh.setSubmittedValue(this.submittedValue);
        evh.setLocalValueSet(this.localValueSet);
    }

    public void apply(IterationStateHolder ish) {
        ish.setIterationState(this.iterationState);
    }

    public void apply(UIForm form) {
        form.setSubmitted(this.submitted);
    }

    private boolean isObjectTransient(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof StateHolder) {
            return ((StateHolder)o).isTransient();
        }
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransient() {
        if (this.iterationState != null) {
            return this.isObjectTransient(this.iterationState);
        }
        if (!this.valid) {
            return false;
        }
        if (this.localValueSet || this.submitted) {
            return false;
        }
        return this.isObjectTransient(this.submittedValue) && this.isObjectTransient(this.value);
    }

    public Object saveState(FacesContext context) {
        if (this.isTransient()) {
            return null;
        }
        if (this.iterationState != null) {
            return new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.iterationState)};
        }
        return new Object[]{this.valid ? Boolean.TRUE : Boolean.FALSE, this.localValueSet ? Boolean.TRUE : Boolean.FALSE, this.submitted ? Boolean.TRUE : Boolean.FALSE, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.submittedValue), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.value)};
    }

    public void restoreState(FacesContext context, Object stateObject) {
        if (stateObject == null) {
            return;
        }
        Object[] state = (Object[])stateObject;
        if (state.length == 1) {
            this.iterationState = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[0]);
        } else {
            this.valid = Boolean.TRUE.equals(state[0]);
            this.localValueSet = Boolean.TRUE.equals(state[1]);
            this.submitted = Boolean.TRUE.equals(state[2]);
            this.submittedValue = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[3]);
            this.value = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[4]);
        }
    }
}

