/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.runner;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.util.TestRunners;
import org.jboss.arquillian.protocol.servlet.runner.SecurityActions;
import org.jboss.arquillian.test.spi.TestResult;

public class ServletTestRunner
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARA_METHOD_NAME = "methodName";
    public static final String PARA_CLASS_NAME = "className";
    public static final String PARA_OUTPUT_MODE = "outputMode";
    public static final String PARA_CMD_NAME = "cmd";
    public static final String OUTPUT_MODE_SERIALIZED = "serializedObject";
    public static final String OUTPUT_MODE_HTML = "html";
    public static final String CMD_NAME_TEST = "test";
    public static final String CMD_NAME_EVENT = "event";
    static ConcurrentHashMap<String, Command<?>> events;
    static ThreadLocal<String> currentCall;

    public void init() throws ServletException {
        events = new ConcurrentHashMap();
        currentCall = new ThreadLocal();
    }

    public void destroy() {
        events.clear();
        currentCall.remove();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.execute(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.execute(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            String outputMode = OUTPUT_MODE_HTML;
            String cmd = CMD_NAME_TEST;
            try {
                String className = null;
                String methodName = null;
                if (request.getParameter(PARA_OUTPUT_MODE) != null) {
                    outputMode = request.getParameter(PARA_OUTPUT_MODE);
                }
                if ((className = request.getParameter(PARA_CLASS_NAME)) == null) {
                    throw new IllegalArgumentException("className must be specified");
                }
                methodName = request.getParameter(PARA_METHOD_NAME);
                if (methodName == null) {
                    throw new IllegalArgumentException("methodName must be specified");
                }
                if (request.getParameter(PARA_CMD_NAME) != null) {
                    cmd = request.getParameter(PARA_CMD_NAME);
                }
                currentCall.set(className + methodName);
                if (CMD_NAME_TEST.equals(cmd)) {
                    this.executeTest(response, outputMode, className, methodName);
                    break block13;
                }
                if (CMD_NAME_EVENT.equals(cmd)) {
                    this.executeEvent(request, response, className, methodName);
                    break block13;
                }
                throw new RuntimeException("Unknown value for parametercmd: " + cmd);
            }
            catch (Exception e) {
                if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
                    this.writeObject(this.createFailedResult(e), response);
                } else {
                    response.sendError(500, e.getMessage());
                }
            }
            finally {
                currentCall.remove();
            }
        }
    }

    public void executeTest(HttpServletResponse response, String outputMode, String className, String methodName) throws ClassNotFoundException, IOException {
        Class<?> testClass = SecurityActions.getThreadContextClassLoader().loadClass(className);
        TestRunner runner = TestRunners.getTestRunner();
        TestResult testResult = runner.execute(testClass, methodName);
        if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
            this.writeObject(testResult, response);
        } else {
            response.setContentType("text/html");
            response.setStatus(200);
            PrintWriter writer = response.getWriter();
            writer.write("<html>\n");
            writer.write("<head><title>TCK Report</title></head>\n");
            writer.write("<body>\n");
            writer.write("<h2>Configuration</h2>\n");
            writer.write("<table>\n");
            writer.write("<tr>\n");
            writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
            writer.write("</tr>\n");
            writer.write("</table>\n");
            writer.write("<h2>Tests</h2>\n");
            writer.write("<table>\n");
            writer.write("<tr>\n");
            writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
            writer.write("</tr>\n");
            writer.write("</table>\n");
            writer.write("</body>\n");
        }
    }

    public void executeEvent(HttpServletRequest request, HttpServletResponse response, String className, String methodName) throws ClassNotFoundException, IOException {
        String eventKey = className + methodName;
        if (request.getContentLength() > 0) {
            response.setStatus(204);
            ObjectInputStream input = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
            Command result = (Command)input.readObject();
            events.put(eventKey, result);
        } else if (events.containsKey(eventKey) && events.get(eventKey).getResult() == null) {
            response.setStatus(200);
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)response.getOutputStream());
            output.writeObject(events.remove(eventKey));
            output.flush();
            output.close();
        } else {
            response.setStatus(204);
        }
    }

    private void writeObject(Object object, HttpServletResponse response) {
        try {
            response.setStatus(200);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            try {
                response.sendError(500, e.getMessage());
            }
            catch (Exception e2) {
                throw new RuntimeException("Could not write to output", e2);
            }
        }
    }

    private TestResult createFailedResult(Throwable throwable) {
        return new TestResult(TestResult.Status.FAILED, throwable);
    }
}

