/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.mail.internet.MimeUtility;

public class Header {
    private final String name;
    private final String value;
    private String sanitizedName;
    private String sanitizedValue;

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Header(String value) {
        this.value = value;
        this.name = null;
    }

    public String getSanitizedName() {
        if (this.sanitizedName == null && this.name != null) {
            try {
                this.sanitizedName = Header.sanitize(this.name);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error santizing Header name " + this.name, e);
            }
        }
        return this.sanitizedName;
    }

    public String getSanitizedValue() {
        if (this.sanitizedValue == null && this.value != null) {
            try {
                this.sanitizedValue = Header.sanitizeValue(this.value);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error santizing Header " + this.name + " value " + this.value, e);
            }
        }
        return this.sanitizedValue;
    }

    public static String sanitize(String value) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(value));
        return reader.readLine();
    }

    public static String sanitizeValue(String value) throws IOException {
        return Header.sanitize(MimeUtility.unfold((String)value));
    }
}

