/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui.context;

import java.io.IOException;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class MailResponseWriter
extends ResponseWriter {
    public static String TEXT_PLAIN_CONTENT_TYPE = "text/plain";
    public static String HTML_PLAIN_CONTENT_TYPE = "text/html";
    private String contentType;
    private ResponseWriter delegate;

    public MailResponseWriter(ResponseWriter responseWriter, String contentType) throws FacesException {
        this.delegate = responseWriter;
        this.contentType = contentType;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return this.delegate.getContentType();
        }
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void startDocument() throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.startDocument();
        }
    }

    public void endDocument() throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.endDocument();
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.startElement(name, component);
        }
    }

    public void endElement(String name) throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.endElement(name);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.writeAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.writeURIAttribute(name, value, componentPropertyName);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (!TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            this.delegate.writeComment(comment);
        }
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        if (TEXT_PLAIN_CONTENT_TYPE.equals(this.getContentType())) {
            if (value == null) {
                throw new NullPointerException("Text must not be null.");
            }
            String strValue = value.toString();
            this.write(strValue);
        } else {
            this.delegate.writeText(value, componentPropertyName);
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf name must not be null");
        }
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        String strValue = new String(cbuf, off, len);
        this.write(strValue);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return this.cloneWithWriter(writer, null);
    }

    public MailResponseWriter cloneWithWriter(Writer writer, String contentType) {
        MailResponseWriter newWriter = new MailResponseWriter(this.delegate.cloneWithWriter(writer), contentType);
        return newWriter;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        String strValue = new String(cbuf, off, len);
        this.write(strValue);
    }

    public void write(int c) throws IOException {
        this.delegate.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        String strValue = new String(cbuf);
        this.write(strValue);
    }

    public void write(String str) throws IOException {
        this.delegate.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        String strValue = str.substring(off, off + len);
        this.write(strValue);
    }
}

