/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.VaultDescriptions;
import org.jboss.as.controller.operations.validation.MapValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

public class VaultAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    static final ParameterValidator codeValidator = new ModelTypeValidator(ModelType.STRING, true);
    static final ParameterValidator optionsValidator = new MapValidator((ParameterValidator)new StringLengthValidator(1), true, 0, Integer.MAX_VALUE);
    private final ParametersValidator validator = new ParametersValidator();
    private final AbstractVaultReader vaultReader;

    public VaultAddHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
        this.validator.registerValidator("code", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        this.validator.registerValidator("vault-options", (ParameterValidator)new MapValidator((ParameterValidator)new StringLengthValidator(1), true, 0, Integer.MAX_VALUE));
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.validator.validate(operation);
        model.get("code").set(operation.get("code"));
        ModelNode options = model.get("vault-options");
        if (operation.hasDefined("vault-options")) {
            for (Property prop : operation.get("vault-options").asPropertyList()) {
                options.get(prop.getName()).set(prop.getValue());
            }
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String vaultClass = null;
        if (model.hasDefined("code")) {
            vaultClass = model.get("code").asString();
        }
        if (this.vaultReader != null) {
            HashMap<String, Object> vaultOptions = new HashMap<String, Object>();
            if (model.hasDefined("vault-options")) {
                for (Property prop : model.get("vault-options").asPropertyList()) {
                    vaultOptions.put(prop.getName(), prop.getValue().asString());
                }
            }
            try {
                this.vaultReader.createVault(vaultClass, vaultOptions);
            }
            catch (VaultReaderException e) {
                throw ServerMessages.MESSAGES.cannotCreateVault(e, e);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        this.vaultReader.destroyVault();
    }

    public ModelNode getModelDescription(Locale locale) {
        return VaultDescriptions.getVaultAddDescription((Locale)locale);
    }
}

