/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.ResourceInjectionTargetMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class ResourceInjectionMetaDataParser
extends MetaDataElementParser {
    public static boolean parse(XMLStreamReader reader, ResourceInjectionMetaData resourceInjection) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LOOKUP_NAME: {
                resourceInjection.setLookupName(ResourceInjectionMetaDataParser.getElementText(reader));
                break;
            }
            case MAPPED_NAME: {
                resourceInjection.setMappedName(ResourceInjectionMetaDataParser.getElementText(reader));
                break;
            }
            case JNDI_NAME: {
                resourceInjection.setJndiName(ResourceInjectionMetaDataParser.getElementText(reader));
                break;
            }
            case IGNORE_DEPENDECY: {
                resourceInjection.setIgnoreDependency(new EmptyMetaData());
                break;
            }
            case INJECTION_TARGET: {
                Set<ResourceInjectionTargetMetaData> injectionTargets = resourceInjection.getInjectionTargets();
                if (injectionTargets == null) {
                    injectionTargets = new HashSet<ResourceInjectionTargetMetaData>();
                    resourceInjection.setInjectionTargets(injectionTargets);
                }
                injectionTargets.add(ResourceInjectionTargetMetaDataParser.parse(reader));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

