/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.AssociationType;

public final class JoinHelper {
    private JoinHelper() {
    }

    public static String[] getAliasedLHSColumnNames(AssociationType type, String alias, int property, OuterJoinLoadable lhsPersister, Mapping mapping) {
        return JoinHelper.getAliasedLHSColumnNames(type, alias, property, 0, lhsPersister, mapping);
    }

    public static String[] getLHSColumnNames(AssociationType type, int property, OuterJoinLoadable lhsPersister, Mapping mapping) {
        return JoinHelper.getLHSColumnNames(type, property, 0, lhsPersister, mapping);
    }

    public static String[] getAliasedLHSColumnNames(AssociationType type, String alias, int property, int begin, OuterJoinLoadable lhsPersister, Mapping mapping) {
        if (type.useLHSPrimaryKey()) {
            return StringHelper.qualify(alias, lhsPersister.getIdentifierColumnNames());
        }
        String propertyName = type.getLHSPropertyName();
        if (propertyName == null) {
            return ArrayHelper.slice(lhsPersister.toColumns(alias, property), begin, type.getColumnSpan(mapping));
        }
        return ((PropertyMapping)((Object)lhsPersister)).toColumns(alias, propertyName);
    }

    public static String[] getLHSColumnNames(AssociationType type, int property, int begin, OuterJoinLoadable lhsPersister, Mapping mapping) {
        if (type.useLHSPrimaryKey()) {
            return lhsPersister.getIdentifierColumnNames();
        }
        String propertyName = type.getLHSPropertyName();
        if (propertyName == null) {
            return ArrayHelper.slice(lhsPersister.getSubclassPropertyColumnNames(property), begin, type.getColumnSpan(mapping));
        }
        return lhsPersister.getPropertyColumnNames(propertyName);
    }

    public static String getLHSTableName(AssociationType type, int property, OuterJoinLoadable lhsPersister) {
        if (type.useLHSPrimaryKey()) {
            return lhsPersister.getTableName();
        }
        String propertyName = type.getLHSPropertyName();
        if (propertyName == null) {
            return lhsPersister.getSubclassPropertyTableName(property);
        }
        String propertyRefTable = lhsPersister.getPropertyTableName(propertyName);
        if (propertyRefTable == null) {
            propertyRefTable = lhsPersister.getSubclassPropertyTableName(property);
        }
        return propertyRefTable;
    }

    public static String[] getRHSColumnNames(AssociationType type, SessionFactoryImplementor factory) {
        String uniqueKeyPropertyName = type.getRHSUniqueKeyPropertyName();
        Joinable joinable = type.getAssociatedJoinable(factory);
        if (uniqueKeyPropertyName == null) {
            return joinable.getKeyColumnNames();
        }
        return ((OuterJoinLoadable)joinable).getPropertyColumnNames(uniqueKeyPropertyName);
    }
}

