/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.hibernate.engine.jdbc.internal.proxy.AbstractStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.BasicStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.CallableStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.ConnectionProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.DatabaseMetaDataProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.ImplicitResultSetProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.ImplicitStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.PreparedStatementProxyHandler;
import org.hibernate.engine.jdbc.internal.proxy.ResultSetProxyHandler;
import org.hibernate.engine.jdbc.spi.InvalidatableWrapper;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;

public class ProxyBuilder {
    public static final Class[] CONNECTION_PROXY_INTERFACES = new Class[]{Connection.class, JdbcWrapper.class};
    public static final Class[] STMNT_PROXY_INTERFACES = new Class[]{Statement.class, JdbcWrapper.class, InvalidatableWrapper.class};
    public static final Class[] PREPARED_STMNT_PROXY_INTERFACES = new Class[]{PreparedStatement.class, JdbcWrapper.class, InvalidatableWrapper.class};
    public static final Class[] CALLABLE_STMNT_PROXY_INTERFACES = new Class[]{CallableStatement.class, JdbcWrapper.class, InvalidatableWrapper.class};
    public static final Class[] RESULTSET_PROXY_INTERFACES = new Class[]{ResultSet.class, JdbcWrapper.class, InvalidatableWrapper.class};
    public static final Class[] METADATA_PROXY_INTERFACES = new Class[]{DatabaseMetaData.class, JdbcWrapper.class};

    public static Connection buildConnection(LogicalConnectionImplementor logicalConnection) {
        ConnectionProxyHandler proxyHandler = new ConnectionProxyHandler(logicalConnection);
        return (Connection)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), CONNECTION_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static Statement buildStatement(Statement statement, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        BasicStatementProxyHandler proxyHandler = new BasicStatementProxyHandler(statement, connectionProxyHandler, connectionProxy);
        return (Statement)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), STMNT_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static Statement buildImplicitStatement(Statement statement, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        if (statement == null) {
            return null;
        }
        ImplicitStatementProxyHandler handler = new ImplicitStatementProxyHandler(statement, connectionProxyHandler, connectionProxy);
        return (Statement)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), STMNT_PROXY_INTERFACES, (InvocationHandler)handler);
    }

    public static PreparedStatement buildPreparedStatement(String sql, Statement statement, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        PreparedStatementProxyHandler proxyHandler = new PreparedStatementProxyHandler(sql, statement, connectionProxyHandler, connectionProxy);
        return (PreparedStatement)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), PREPARED_STMNT_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static CallableStatement buildCallableStatement(String sql, CallableStatement statement, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        CallableStatementProxyHandler proxyHandler = new CallableStatementProxyHandler(sql, statement, connectionProxyHandler, connectionProxy);
        return (CallableStatement)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), CALLABLE_STMNT_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static ResultSet buildResultSet(ResultSet resultSet, AbstractStatementProxyHandler statementProxyHandler, Statement statementProxy) {
        ResultSetProxyHandler proxyHandler = new ResultSetProxyHandler(resultSet, statementProxyHandler, statementProxy);
        return (ResultSet)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), RESULTSET_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static ResultSet buildImplicitResultSet(ResultSet resultSet, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        ImplicitResultSetProxyHandler proxyHandler = new ImplicitResultSetProxyHandler(resultSet, connectionProxyHandler, connectionProxy);
        return (ResultSet)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), RESULTSET_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static ResultSet buildImplicitResultSet(ResultSet resultSet, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy, Statement sourceStatement) {
        ImplicitResultSetProxyHandler proxyHandler = new ImplicitResultSetProxyHandler(resultSet, connectionProxyHandler, connectionProxy, sourceStatement);
        return (ResultSet)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), RESULTSET_PROXY_INTERFACES, (InvocationHandler)proxyHandler);
    }

    public static DatabaseMetaData buildDatabaseMetaData(DatabaseMetaData metaData, ConnectionProxyHandler connectionProxyHandler, Connection connectionProxy) {
        DatabaseMetaDataProxyHandler handler = new DatabaseMetaDataProxyHandler(metaData, connectionProxyHandler, connectionProxy);
        return (DatabaseMetaData)Proxy.newProxyInstance(JdbcWrapper.class.getClassLoader(), METADATA_PROXY_INTERFACES, (InvocationHandler)handler);
    }
}

