/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestContext;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.util.value.IValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeModifier
extends AbstractBehavior
implements IClusterable {
    public static final String VALUELESS_ATTRIBUTE_ADD = "VA_ADD";
    public static final String VALUELESS_ATTRIBUTE_REMOVE = "VA_REMOVE";
    private static final long serialVersionUID = 1L;
    private final boolean addAttributeIfNotPresent;
    private final String attribute;
    private boolean enabled;
    private final String pattern;
    private final IModel<?> replaceModel;

    public AttributeModifier(String attribute, boolean addAttributeIfNotPresent, IModel<?> replaceModel) {
        this(attribute, null, addAttributeIfNotPresent, replaceModel);
    }

    public AttributeModifier(String attribute, IModel<?> replaceModel) {
        this(attribute, null, false, replaceModel);
    }

    public AttributeModifier(String attribute, String pattern, boolean addAttributeIfNotPresent, IModel<?> replaceModel) {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute parameter cannot be null");
        }
        this.attribute = attribute;
        this.pattern = pattern;
        this.enabled = true;
        this.addAttributeIfNotPresent = addAttributeIfNotPresent;
        this.replaceModel = replaceModel;
    }

    public AttributeModifier(String attribute, String pattern, IModel<?> replaceModel) {
        this(attribute, pattern, false, replaceModel);
    }

    @Override
    public final void detach(Component component) {
        if (this.replaceModel != null) {
            this.replaceModel.detach();
        }
    }

    public final boolean getAddAttributeIfNotPresent() {
        return this.addAttributeIfNotPresent;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    public final String getPattern() {
        return this.pattern;
    }

    @Deprecated
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isEnabled(Component component) {
        return this.enabled;
    }

    @Override
    public final void onComponentTag(Component component, ComponentTag tag) {
        if (tag.getType() != XmlTag.CLOSE) {
            this.replaceAttributeValue(component, tag);
        }
    }

    @Deprecated
    public void replaceAttibuteValue(Component component, ComponentTag tag) {
        this.replaceAttributeValue(component, tag);
    }

    public final void replaceAttributeValue(Component component, ComponentTag tag) {
        if (this.isEnabled(component)) {
            String newValue;
            IValueMap attributes = tag.getAttributes();
            Object replacementValue = this.getReplacementOrNull(component);
            if (VALUELESS_ATTRIBUTE_ADD.equals(replacementValue)) {
                attributes.put(this.attribute, null);
            } else if (VALUELESS_ATTRIBUTE_REMOVE.equals(replacementValue)) {
                attributes.remove(this.attribute);
            } else if (attributes.containsKey(this.attribute)) {
                String newValue2;
                String value = this.toStringOrNull(attributes.get(this.attribute));
                if ((this.pattern == null || value.matches(this.pattern)) && (newValue2 = this.newValue(value, this.toStringOrNull(replacementValue))) != null) {
                    attributes.put(this.attribute, this.getContextRelativeValue(newValue2));
                }
            } else if (this.addAttributeIfNotPresent && (newValue = this.newValue(null, this.toStringOrNull(replacementValue))) != null) {
                attributes.put(this.attribute, this.getContextRelativeValue(newValue));
            }
        }
    }

    protected String getContextRelativeValue(String value) {
        RequestContext rc;
        if (("href".equals(this.attribute) || "src".equals(this.attribute)) && (rc = RequestContext.get()).isPortletRequest() && !value.startsWith("http://") && !value.startsWith("https://")) {
            value = "href".equals(this.attribute) ? ((Object)((PortletRequestContext)rc).encodeRenderURL(value)).toString() : ((Object)((PortletRequestContext)rc).encodeSharedResourceURL(value)).toString();
        }
        return value;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "[AttributeModifier attribute=" + this.attribute + ", enabled=" + this.enabled + ", pattern=" + this.pattern + ", replacementModel=" + this.replaceModel + "]";
    }

    private Object getReplacementOrNull(Component component) {
        IModel<?> model = this.replaceModel;
        if (model instanceof IComponentAssignedModel) {
            model = ((IComponentAssignedModel)model).wrapOnAssignment(component);
        }
        return model != null ? model.getObject() : null;
    }

    private String toStringOrNull(Object replacementValue) {
        return replacementValue != null ? replacementValue.toString() : null;
    }

    protected final IModel<?> getReplaceModel() {
        return this.replaceModel;
    }

    protected String newValue(String currentValue, String replacementValue) {
        return replacementValue;
    }
}

