/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.util.string.IStringIterator;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageParameters
extends ValueMap {
    public static final PageParameters NULL = new PageParameters();
    private static final long serialVersionUID = 1L;

    public PageParameters() {
        this.setOnRequestCycle();
    }

    public PageParameters(Map<String, ?> parameterMap) {
        super((Map<? extends String, ? extends Object>)parameterMap);
        this.setOnRequestCycle();
    }

    public PageParameters(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    @Deprecated
    public PageParameters(String keyValuePairs, String delimiter) {
        this.setOnRequestCycle();
        StringList pairs = StringList.tokenize(keyValuePairs, delimiter);
        IStringIterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String value;
            String key;
            String pair = iterator.next();
            int pos = pair.indexOf(61);
            if (pos == 0) {
                throw new IllegalArgumentException("URL parameter is missing the lvalue: " + pair);
            }
            if (pos != -1) {
                key = pair.substring(0, pos).trim();
                value = pair.substring(pos + 1).trim();
                this.add(key, value);
                continue;
            }
            key = pair.trim();
            value = null;
            this.add(key, value);
        }
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    private void setOnRequestCycle() {
        RequestCycle cycle = RequestCycle.get();
        if (cycle != null) {
            cycle.setPageParameters(this);
        }
    }

    public Map<String, String[]> toRequestParameters() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getValue() == null) {
                params.put((String)entry.getKey(), (String[])null);
                continue;
            }
            if (entry.getValue().getClass().isArray()) {
                Object[] arr = (Object[])entry.getValue();
                String[] str = new String[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    str[i] = arr[i].toString();
                }
                params.put((String)entry.getKey(), str);
                continue;
            }
            params.put((String)entry.getKey(), new String[]{entry.getValue().toString()});
        }
        return params;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        PageParameters other = (PageParameters)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (String key : this.keySet()) {
            Object second;
            Object first = this.get(key);
            if (first == (second = other.get(key))) continue;
            if (first != null && second != null) {
                Class<?> firstClazz = first.getClass();
                Class<?> secondClazz = second.getClass();
                if (firstClazz.isArray() && secondClazz.isArray() || firstClazz.isArray() || secondClazz.isArray()) {
                    Object[] secondArray;
                    Object[] objectArray;
                    Object[] firstArray;
                    Object[] objectArray2;
                    if (!first.getClass().isArray()) {
                        Object[] objectArray3 = new Object[1];
                        objectArray2 = objectArray3;
                        objectArray3[0] = first;
                    } else {
                        objectArray2 = firstArray = (Object[])first;
                    }
                    if (!second.getClass().isArray()) {
                        Object[] objectArray4 = new Object[1];
                        objectArray = objectArray4;
                        objectArray4[0] = second;
                    } else {
                        objectArray = (Object[])second;
                    }
                    if (Arrays.equals(firstArray, secondArray = objectArray)) continue;
                    return false;
                }
                if (first.equals(second)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

