/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.AbstractRestartResponseException;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.ListenerInterfaceRequestTarget;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestListenerInterface {
    private static final Map<String, RequestListenerInterface> interfaces = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(RequestListenerInterface.class);
    private Method method;
    private final String name;
    private boolean recordsPageVersion = true;

    public static final RequestListenerInterface forName(String interfaceName) {
        return interfaces.get(interfaceName);
    }

    public RequestListenerInterface(Class<? extends IRequestListener> listenerInterfaceClass) {
        this(listenerInterfaceClass, true);
    }

    public RequestListenerInterface(Class<? extends IRequestListener> listenerInterfaceClass, boolean recordsPageVersion) {
        if (!IRequestListener.class.isAssignableFrom(listenerInterfaceClass)) {
            throw new IllegalArgumentException("Class " + listenerInterfaceClass + " must extend IRequestListener");
        }
        this.recordsPageVersion = recordsPageVersion;
        Method[] methods = listenerInterfaceClass.getMethods();
        if (methods.length == 1) {
            if (methods[0].getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Method " + methods[0] + " in interface " + listenerInterfaceClass + " cannot take any arguments");
            }
        } else {
            throw new IllegalArgumentException("Interface " + listenerInterfaceClass + " can have only one method");
        }
        this.method = methods[0];
        this.name = Classes.simpleName(listenerInterfaceClass);
        this.register();
    }

    public final Method getMethod() {
        return this.method;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean getRecordsPageVersion() {
        return this.recordsPageVersion;
    }

    public final void invoke(Page page, Component component) {
        if (!component.isEnabledInHierarchy() || !component.isVisibleInHierarchy()) {
            log.warn("component not enabled or visible; ignoring call. Component: " + component);
            return;
        }
        page.beforeCallComponent(component, this);
        try {
            this.method.invoke((Object)component, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AbstractRestartResponseException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof WicketRuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException("Method " + this.method.getName() + " of " + this.method.getDeclaringClass() + " targeted at component " + component + " threw an exception", e);
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Method " + this.method.getName() + " of " + this.method.getDeclaringClass() + " targeted at component " + component + " threw an exception", e);
        }
        finally {
            page.afterCallComponent(component, this);
        }
    }

    public IRequestTarget newRequestTarget(Page page, Component component, RequestListenerInterface listener, RequestParameters requestParameters) {
        return new ListenerInterfaceRequestTarget(page, component, listener, requestParameters);
    }

    public void register() {
        this.registerRequestListenerInterface(this);
    }

    public String toString() {
        return "[RequestListenerInterface name=" + this.name + ", method=" + this.method + "]";
    }

    private final void registerRequestListenerInterface(RequestListenerInterface requestListenerInterface) {
        RequestListenerInterface existingInterface = RequestListenerInterface.forName(requestListenerInterface.getName());
        if (existingInterface != null && existingInterface.getMethod() != requestListenerInterface.getMethod()) {
            throw new IllegalStateException("Cannot register listener interface " + requestListenerInterface + " because it conflicts with the already registered interface " + existingInterface);
        }
        interfaces.put(requestListenerInterface.getName(), requestListenerInterface);
        log.info("registered listener interface " + this);
    }
}

