/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.util.io.Streams;

public abstract class BlobImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;

    public BlobImageResource(Locale locale) {
        super(locale);
    }

    public BlobImageResource(String format, Locale locale) {
        super(format, locale);
    }

    public BlobImageResource(String format) {
        super(format);
    }

    public BlobImageResource() {
    }

    protected byte[] getImageData() {
        try {
            Blob blob = this.getBlob();
            if (blob != null) {
                InputStream in = blob.getBinaryStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy(in, out);
                return out.toByteArray();
            }
            return new byte[0];
        }
        catch (SQLException e) {
            throw new WicketRuntimeException("Error while reading image data", e);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Error while reading image data", e);
        }
    }

    protected abstract Blob getBlob();
}

