/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.portlet.EmbeddedPortletHeaderResponse;
import org.apache.wicket.protocol.http.portlet.WicketFilterPortletContext;
import org.apache.wicket.protocol.http.portlet.WicketPortlet;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;

public class PortletRequestContext
extends RequestContext {
    private final WicketFilterPortletContext filterContext;
    private final PortletConfig portletConfig;
    private final PortletRequest portletRequest;
    private final PortletResponse portletResponse;
    private final MimeResponse mimeResponse;
    private final IHeaderResponse headerResponse;
    private final String wicketUrlPortletParameter;
    private final boolean ajax;
    private final boolean embedded;
    private final boolean resourceRequest;
    private final String[] lastEncodedUrl = new String[2];

    public PortletRequestContext(WicketFilterPortletContext filterContext, ServletWebRequest request, WebResponse response) {
        this.filterContext = filterContext;
        HttpServletRequest servletRequest = request.getHttpServletRequest();
        this.portletConfig = (PortletConfig)servletRequest.getAttribute("javax.portlet.config");
        this.portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        this.portletResponse = (PortletResponse)servletRequest.getAttribute("javax.portlet.response");
        this.wicketUrlPortletParameter = (String)this.portletRequest.getAttribute(WicketPortlet.WICKET_URL_PORTLET_PARAMETER_ATTR);
        this.ajax = request.isAjax();
        this.resourceRequest = this.portletRequest.getAttribute("javax.portlet.lifecycle_phase").equals("RESOURCE_PHASE");
        this.mimeResponse = this.resourceRequest || this.portletRequest.getAttribute("javax.portlet.lifecycle_phase").equals("RENDER_PHASE") ? (MimeResponse)this.portletResponse : null;
        this.embedded = !this.ajax && !this.resourceRequest;
        this.headerResponse = this.embedded ? this.newPortletHeaderResponse(response) : null;
    }

    protected IHeaderResponse newPortletHeaderResponse(Response response) {
        return new EmbeddedPortletHeaderResponse(response);
    }

    public String getLastEncodedPath() {
        if (this.lastEncodedUrl != null) {
            return this.lastEncodedUrl[1];
        }
        return null;
    }

    public String getLastEncodedPath(String url) {
        if (url != null && this.lastEncodedUrl != null && url.equals(this.lastEncodedUrl[0])) {
            return this.lastEncodedUrl[1];
        }
        return null;
    }

    protected String saveLastEncodedUrl(String url, String path) {
        this.lastEncodedUrl[0] = url;
        this.lastEncodedUrl[1] = path;
        return url;
    }

    public CharSequence encodeActionURL(CharSequence path) {
        return this.encodeActionURL(path, false);
    }

    public CharSequence encodeActionURL(CharSequence path, boolean forceActionURL) {
        if (!forceActionURL && this.resourceRequest || RequestCycle.get().isUrlForNewWindowEncoding()) {
            return this.encodeResourceURL(path);
        }
        if (path != null) {
            path = this.getQualifiedPath(path);
            if (this.mimeResponse != null) {
                PortletURL url = this.mimeResponse.createActionURL();
                url.setParameter(this.wicketUrlPortletParameter, ((Object)path).toString());
                path = this.saveLastEncodedUrl(url.toString(), ((Object)path).toString());
            }
        }
        return path;
    }

    public String encodeMarkupId(String markupId) {
        if (markupId != null) {
            markupId = this.getNamespace() + "_" + markupId;
        }
        return markupId;
    }

    public CharSequence encodeRenderURL(CharSequence path) {
        return this.encodeRenderURL(path, false);
    }

    public CharSequence encodeRenderURL(CharSequence path, boolean forceRenderURL) {
        if (!forceRenderURL && this.resourceRequest || RequestCycle.get().isUrlForNewWindowEncoding()) {
            return this.encodeResourceURL(path);
        }
        if (path != null) {
            path = this.getQualifiedPath(path);
            if (this.mimeResponse != null) {
                PortletURL url = this.mimeResponse.createRenderURL();
                url.setParameter(this.wicketUrlPortletParameter + this.portletRequest.getPortletMode().toString(), ((Object)path).toString());
                path = this.saveLastEncodedUrl(url.toString(), ((Object)path).toString());
            }
        }
        return path;
    }

    public CharSequence encodeResourceURL(CharSequence path) {
        if (path != null) {
            path = this.getQualifiedPath(path);
            if (this.mimeResponse != null) {
                try {
                    ResourceURL url = this.mimeResponse.createResourceURL();
                    String resourceID = ((Object)path).toString();
                    url.setResourceID(resourceID);
                    path = this.saveLastEncodedUrl(url.toString(), resourceID);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return path;
    }

    public CharSequence encodeSharedResourceURL(CharSequence path) {
        if (path != null) {
            String url = this.filterContext.encodeWindowIdInPath(this.getPortletWindowId(), path);
            return this.saveLastEncodedUrl(url, url);
        }
        return null;
    }

    public IHeaderResponse getHeaderResponse() {
        return this.headerResponse;
    }

    public CharSequence getNamespace() {
        return this.portletResponse != null ? this.portletResponse.getNamespace() : "";
    }

    public boolean isPortletRequest() {
        return true;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    protected String getQualifiedPath(CharSequence path) {
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        return request.getServletPath() + "/" + path;
    }

    protected String getPortletWindowId() {
        return this.portletRequest.getWindowID();
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    public boolean isAjax() {
        return this.ajax;
    }
}

