/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.https.HttpsRequestCycleProcessor;

class SwitchProtocolRequestTarget
implements IRequestTarget {
    private final Protocol protocol;
    private final IRequestTarget target;

    public SwitchProtocolRequestTarget(Protocol protocol) {
        this(protocol, null);
    }

    public SwitchProtocolRequestTarget(Protocol protocol, IRequestTarget target) {
        if (protocol == null) {
            throw new IllegalArgumentException("Argument 'protocol' may not be null.");
        }
        if (protocol == Protocol.PRESERVE_CURRENT) {
            throw new IllegalArgumentException("Argument 'protocol' may not have value '" + Protocol.PRESERVE_CURRENT.toString() + "'.");
        }
        this.protocol = protocol;
        this.target = target;
    }

    public void detach(RequestCycle requestCycle) {
    }

    protected String getUrl(String protocol, Integer port, HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append(protocol);
        result.append("://");
        result.append(request.getServerName());
        if (port != null) {
            result.append(":");
            result.append(port);
        }
        result.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            result.append("?");
            result.append(request.getQueryString());
        }
        return result.toString();
    }

    public void respond(RequestCycle requestCycle) {
        WebRequest webRequest = (WebRequest)requestCycle.getRequest();
        HttpServletRequest request = webRequest.getHttpServletRequest();
        HttpsRequestCycleProcessor processor = (HttpsRequestCycleProcessor)requestCycle.getProcessor();
        Integer port = null;
        if (this.protocol == Protocol.HTTP) {
            if (processor.getConfig().getHttpPort() != 80) {
                port = processor.getConfig().getHttpPort();
            }
        } else if (this.protocol == Protocol.HTTPS && processor.getConfig().getHttpsPort() != 443) {
            port = processor.getConfig().getHttpsPort();
        }
        String url = this.target == null ? this.getUrl(this.protocol.toString().toLowerCase(), port, request) : ((Object)requestCycle.urlFor(this.target)).toString();
        WebResponse response = (WebResponse)requestCycle.getResponse();
        response.redirect(url);
    }

    public static IRequestTarget requireProtocol(Protocol protocol) {
        return SwitchProtocolRequestTarget.requireProtocol(protocol, null);
    }

    public static IRequestTarget requireProtocol(Protocol protocol, IRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)requestCycle.getRequest();
        HttpServletRequest request = webRequest.getHttpServletRequest();
        if (protocol == null || protocol == Protocol.PRESERVE_CURRENT || request.getScheme().equals(protocol.toString().toLowerCase())) {
            return null;
        }
        return new SwitchProtocolRequestTarget(protocol, target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        HTTP,
        HTTPS,
        PRESERVE_CURRENT;

    }
}

