/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.request.target.coding.HybridUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedParamHybridUrlCodingStrategy
extends HybridUrlCodingStrategy {
    private static Logger logger = LoggerFactory.getLogger(MixedParamHybridUrlCodingStrategy.class);
    private final String[] parameterNames;
    private boolean ignoreUndeclaredParameters = true;

    public MixedParamHybridUrlCodingStrategy(String mountPath, Class<? extends Page> pageClass, boolean redirectOnBookmarkableRequest, String[] parameterNames) {
        super(mountPath, pageClass, redirectOnBookmarkableRequest);
        this.parameterNames = parameterNames;
    }

    public MixedParamHybridUrlCodingStrategy(String mountPath, Class<? extends Page> pageClass, String[] parameterNames) {
        super(mountPath, pageClass);
        this.parameterNames = parameterNames;
    }

    public MixedParamHybridUrlCodingStrategy setIgnoreUndeclaredParameters(boolean ignoreUndeclaredParameters) {
        this.ignoreUndeclaredParameters = ignoreUndeclaredParameters;
        return this;
    }

    @Override
    protected void appendParameters(AppendingStringBuffer url, Map<String, ?> parameters) {
        if (!url.endsWith("/")) {
            url.append("/");
        }
        HashSet<String> parameterNamesToAdd = new HashSet<String>(parameters.keySet());
        boolean foundParameter = false;
        int lastSpecifiedParameter = this.parameterNames.length;
        while (lastSpecifiedParameter != 0 && !foundParameter) {
            foundParameter = parameters.containsKey(this.parameterNames[--lastSpecifiedParameter]);
        }
        if (foundParameter) {
            for (int i = 0; i <= lastSpecifiedParameter; ++i) {
                String value;
                String parameterName = this.parameterNames[i];
                Object param = parameters.get(parameterName);
                String string = param instanceof String[] ? ((String[])param)[0] : (value = param == null ? null : param.toString());
                if (value == null) {
                    value = "";
                }
                if (!url.endsWith("/")) {
                    url.append("/");
                }
                url.append(this.urlEncodePathComponent(value));
                parameterNamesToAdd.remove(parameterName);
            }
        }
        if (!parameterNamesToAdd.isEmpty()) {
            boolean first = true;
            for (String parameterName : parameterNamesToAdd) {
                url.append(first ? (char)'?' : '&');
                Object param = parameters.get(parameterName);
                String value = param instanceof String[] ? ((String[])param)[0] : (param == null ? null : param.toString());
                url.append(this.urlEncodeQueryComponent(parameterName)).append("=").append(this.urlEncodeQueryComponent(value));
                first = false;
            }
        }
    }

    @Override
    protected String addPageInfo(String url, HybridUrlCodingStrategy.PageInfo pageInfo) {
        if (pageInfo == null) {
            return url;
        }
        if (url.indexOf(63) == -1) {
            return url + this.getBeginSeparator() + pageInfo.toString() + this.getEndSeparator();
        }
        return Strings.firstPathComponent(url, '?') + this.getBeginSeparator() + pageInfo.toString() + this.getEndSeparator() + '?' + Strings.afterFirstPathComponent(url, '?');
    }

    @Override
    protected ValueMap decodeParameters(String urlFragment, Map<String, ?> urlParameters) {
        PageParameters params = new PageParameters();
        params.putAll((Map<? extends String, ? extends Object>)urlParameters);
        String urlPath = urlFragment;
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.length() > 0) {
            String[] pathParts = urlPath.split("/");
            if (pathParts.length > this.parameterNames.length) {
                String msg = String.format("Found more URL path parts then expected, these will be ignored. Url: '%s', mountpath: '%s', urlPath: '%s', expected %d parameters was %d", this.getRequestUrl(), this.getMountPath(), urlPath, this.parameterNames.length, pathParts.length);
                if (this.ignoreUndeclaredParameters) {
                    logger.info(msg);
                } else {
                    throw new IllegalArgumentException(msg);
                }
            }
            int actualParameterCount = Math.min(pathParts.length, this.parameterNames.length);
            for (int i = 0; i < actualParameterCount; ++i) {
                params.put(this.parameterNames[i], (Object)this.urlDecodePathComponent(pathParts[i]));
            }
        }
        return params;
    }

    private String getRequestUrl() {
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        return request.getRequestURL().toString();
    }
}

