/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.Map;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTemplateResourceReference
extends ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final TextTemplate textTemplate;
    private final IModel<Map<String, Object>> variablesModel;

    public TextTemplateResourceReference(Class<?> scope, String fileName, IModel<Map<String, Object>> variablesModel) {
        super(scope, fileName);
        this.textTemplate = new PackagedTextTemplate(scope, fileName);
        this.variablesModel = variablesModel;
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, IModel<Map<String, Object>> variablesModel) {
        super(scope, fileName);
        this.textTemplate = new PackagedTextTemplate(scope, fileName, contentType);
        this.variablesModel = variablesModel;
    }

    public TextTemplateResourceReference(Class<?> scope, String fileName, String contentType, String encoding, IModel<Map<String, Object>> variablesModel) {
        super(scope, fileName);
        this.textTemplate = new PackagedTextTemplate(scope, fileName, contentType, encoding);
        this.variablesModel = variablesModel;
    }

    @Override
    protected Resource newResource() {
        return new Resource(){
            private static final long serialVersionUID = 1L;

            public IResourceStream getResourceStream() {
                String stringValue = TextTemplateResourceReference.this.textTemplate.asString((Map)TextTemplateResourceReference.this.variablesModel.getObject());
                TextTemplateResourceReference.this.variablesModel.detach();
                return new StringResourceStream(stringValue, TextTemplateResourceReference.this.textTemplate.getContentType());
            }
        };
    }

    @Override
    public Time lastModifiedTime() {
        return this.textTemplate.lastModifiedTime();
    }
}

