/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.wicket.AbortException;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPageFactory
implements IPageFactory {
    private final Map<Class<? extends Page>, Constructor<? extends Page>> constructorForClass = Generics.newConcurrentHashMap();

    @Override
    public final <C extends Page> Page newPage(Class<C> pageClass) {
        Constructor<Page> constructor = this.constructor(pageClass);
        if (constructor != null) {
            return this.createPage(constructor, null);
        }
        constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            return this.createPage(constructor, new PageParameters());
        }
        throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does neither have a constructor with PageParameter nor a default constructor");
    }

    @Override
    public final <C extends Page> Page newPage(Class<C> pageClass, PageParameters parameters) {
        if (parameters == null) {
            return this.newPage(pageClass);
        }
        Constructor<Page> constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            return this.createPage(constructor, parameters);
        }
        constructor = this.constructor(pageClass);
        if (constructor != null) {
            return this.createPage(constructor, null);
        }
        throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does neither have a constructor with PageParameter nor a default constructor");
    }

    private final <C extends Page> Constructor<? extends Page> constructor(Class<C> pageClass) {
        try {
            return pageClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private final <C extends Page> Constructor<? extends Page> constructor(Class<C> pageClass, Class<PageParameters> argumentType) {
        Constructor<Page> constructor = this.constructorForClass.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getConstructor(argumentType);
                this.constructorForClass.put(pageClass, constructor);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return constructor;
    }

    private final Page createPage(Constructor<? extends Page> constructor, PageParameters argument) {
        try {
            if (argument != null) {
                return constructor.newInstance(argument);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AbortException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
    }

    private String createDescription(Constructor<? extends Page> constructor, PageParameters argument) {
        if (argument != null) {
            return "Can't instantiate page using constructor " + constructor + " and argument " + argument;
        }
        return "Can't instantiate page using constructor " + constructor;
    }
}

