/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session.pagemap;

import org.apache.wicket.AccessStackPageMap;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.session.pagemap.IPageMapEvictionStrategy;

public class LeastRecentlyAccessedEvictionStrategy
implements IPageMapEvictionStrategy {
    private static final long serialVersionUID = 1L;
    private final int maxVersions;

    public LeastRecentlyAccessedEvictionStrategy(int maxVersions) {
        if (maxVersions < 1) {
            throw new IllegalArgumentException("Value for maxVersions must be >= 1");
        }
        this.maxVersions = maxVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(IPageMap pageMap) {
        if (pageMap instanceof AccessStackPageMap) {
            Session session = Session.get();
            synchronized (session) {
                AccessStackPageMap accessPM = (AccessStackPageMap)pageMap;
                if (accessPM.getVersions() > this.maxVersions) {
                    AccessStackPageMap.Access oldestAccess = (AccessStackPageMap.Access)accessPM.getAccessStack().remove(0);
                    IPageMapEntry oldestEntry = pageMap.getEntry(oldestAccess.getId());
                    if (oldestEntry instanceof Page) {
                        Page page = (Page)oldestEntry;
                        if (page.getVersions() > 1) {
                            page.expireOldestVersion();
                        } else {
                            accessPM.removeEntry(page);
                        }
                    } else if (oldestEntry != null) {
                        accessPM.removeEntry(oldestEntry);
                    }
                }
            }
        }
    }

    public String toString() {
        return "[LeastRecentlyAccessedEvictionStrategy maxVersions = " + this.maxVersions + "]";
    }
}

