/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.io.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private OutputStream currentOutputStream;
    private ByteArrayOutputStream memoryOutputStream;
    private File outputFile;
    private final FileFactory fileFactory;

    public DeferredFileOutputStream(int threshold, File outputFile) {
        super(threshold);
        if (outputFile == null) {
            throw new IllegalArgumentException("output file must be specified");
        }
        this.outputFile = outputFile;
        this.fileFactory = null;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    public DeferredFileOutputStream(int threshold, FileFactory fileFactory) {
        super(threshold);
        if (fileFactory == null) {
            throw new IllegalArgumentException("FileFactory must be specified");
        }
        this.fileFactory = fileFactory;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        byte[] data = this.memoryOutputStream.toByteArray();
        if (this.outputFile == null) {
            this.outputFile = this.fileFactory.createFile();
        }
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        fos.write(data);
        this.currentOutputStream = fos;
        this.memoryOutputStream = null;
    }

    public static interface FileFactory {
        public File createFile();
    }
}

