/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

public class Cloud
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _domain;
    private String _port;
    private String _path;
    private String _registerProcedure;
    private String _protocol;

    public Cloud() {
    }

    public static Cloud create() {
        return new Cloud();
    }

    public Cloud(String domain, String port, String path, String registerProcedure, String protocol) {
        this.setDomain(domain);
        this.setPath(path);
        this.setPort(port);
        this.setRegisterProcedure(registerProcedure);
        this.setProtocol(protocol);
    }

    public String getDomain() {
        return this._domain;
    }

    public Cloud setDomain(String domain) {
        this._domain = domain;
        return this;
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public String getPath() {
        return this._path;
    }

    public Cloud setPath(String path) {
        this._path = path;
        return this;
    }

    public String getRegisterProcedure() {
        return this._registerProcedure;
    }

    public Cloud setRegisterProcedure(String registerProcedure) {
        this._registerProcedure = registerProcedure;
        return this;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public Cloud setProtocol(String protocol) {
        this._protocol = protocol;
        return this;
    }

    public void validate(FeedFormat format) throws ValidationException {
        if (format != FeedFormat.RSS20) {
            return;
        }
        ValidationUtils.validateNotNull("Cloud: All fields in the cloud object should be not null", this._domain, this._path, this._port, this._protocol, this._registerProcedure);
        if (!(this._protocol.equals("xml-rpc") || this._protocol.equals("http-post") || this._protocol.equals("soap"))) {
            throw new ValidationException("Cloud: Protocol should be one of the following: xml-rpc, soap, http-post");
        }
        if (this._port != null && (Integer.parseInt(this._port) < 0 || Integer.parseInt(this._port) > 65535)) {
            throw new ValidationException("Cloud: Invalid port number");
        }
    }
}

