/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.backward.impl;

import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.Content;
import yarfraw.core.datamodel.Id;
import yarfraw.core.datamodel.Image;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Link;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Text;
import yarfraw.generated.atom10.elements.CategoryType;
import yarfraw.generated.atom10.elements.ContentType;
import yarfraw.generated.atom10.elements.DateTimeType;
import yarfraw.generated.atom10.elements.EntryType;
import yarfraw.generated.atom10.elements.IconType;
import yarfraw.generated.atom10.elements.IdType;
import yarfraw.generated.atom10.elements.LinkType;
import yarfraw.generated.atom10.elements.PersonType;
import yarfraw.generated.atom10.elements.TextType;
import yarfraw.generated.atom10.elements.UriType;
import yarfraw.io.parser.ElementQName;
import yarfraw.utils.XMLUtils;

class Atom10MappingUtils {
    private static final Log LOG = LogFactory.getLog(Atom10MappingUtils.class);

    Atom10MappingUtils() {
    }

    public static Text toText(TextType in) {
        Text ret = new Text();
        for (Object o : in.getContent()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                JAXBElement jaxb = (JAXBElement)o;
                Object val = jaxb.getValue();
                ret.setText(String.valueOf(val));
                continue;
            }
            if (o instanceof Element) {
                ret.setXhtmlDiv((Element)o);
                continue;
            }
            ret.setText(String.valueOf(o));
        }
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        return ret;
    }

    public static CategorySubject toCategorySubject(CategoryType in) {
        CategorySubject ret = new CategorySubject();
        ret.setLabel(in.getLabel());
        ret.setCategoryOrSubjectOrTerm(in.getTerm());
        ret.setDomainOrScheme(in.getScheme());
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        return ret;
    }

    public static Person toPersonType(PersonType in) {
        Person ret = new Person();
        for (Object o : in.getNameOrUriOrEmail()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                JAXBElement jaxb = (JAXBElement)o;
                Object val = jaxb.getValue();
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_EMAIL)) {
                    ret.setEmailOrText((String)val);
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_NAME)) {
                    ret.setName((String)val);
                    continue;
                }
                if (val instanceof UriType) {
                    ret.setUri(((UriType)val).getValue());
                    continue;
                }
                LOG.warn((Object)("Unexpected JAXB Element: " + ToStringBuilder.reflectionToString((Object)val)));
                continue;
            }
            if (o instanceof Element) {
                ret.getOtherElements().add((Element)o);
                continue;
            }
            LOG.warn((Object)("Unexpected Element: " + ToStringBuilder.reflectionToString((Object)o)));
        }
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        return ret;
    }

    private static Content toContent(ContentType in) {
        Content ret = new Content();
        for (Object o : in.getContent()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                JAXBElement jaxb = (JAXBElement)o;
                Object val = jaxb.getValue();
                ret.addContentText(String.valueOf(val));
                continue;
            }
            if (o instanceof Element) {
                ret.getOtherElements().add((Element)o);
                continue;
            }
            String s = String.valueOf(o);
            if (!StringUtils.isNotBlank((String)s)) continue;
            ret.addContentText(s);
        }
        ret.setSrc(in.getSrc());
        ret.setType(in.getType());
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        return ret;
    }

    public static ItemEntry toItem(EntryType in) {
        ItemEntry ret = new ItemEntry();
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        for (Object o : in.getAuthorOrCategoryOrContent()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                TextType text;
                DateTimeType dt;
                JAXBElement jaxb = (JAXBElement)o;
                Object val = jaxb.getValue();
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_AUTHOR)) {
                    ret.addAuthorOrCreator(Atom10MappingUtils.toPersonType((PersonType)val));
                    continue;
                }
                if (val instanceof CategoryType) {
                    ret.addCategorySubject(Atom10MappingUtils.toCategorySubject((CategoryType)val));
                    continue;
                }
                if (val instanceof ContentType) {
                    ret.setContent(Atom10MappingUtils.toContent((ContentType)val));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_CONTRIBUTOR)) {
                    ret.addContributor(Atom10MappingUtils.toPersonType((PersonType)val));
                    continue;
                }
                if (val instanceof LinkType) {
                    ret.addLink(Atom10MappingUtils.toAtomLink((LinkType)val));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_PUBLISHED)) {
                    dt = (DateTimeType)val;
                    if (dt.getValue() == null) continue;
                    ret.setPubDate(dt.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_RIGHTS)) {
                    text = (TextType)val;
                    ret.setRights(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_SUMMARY)) {
                    text = (TextType)val;
                    ret.setDescriptionOrSummary(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_TITLE)) {
                    text = (TextType)val;
                    ret.setTitle(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.ATOM10_UPDATED)) {
                    dt = (DateTimeType)val;
                    if (dt.getValue() == null) continue;
                    ret.setUpdatedDate(dt.getValue());
                    continue;
                }
                if (val instanceof IdType) {
                    ret.setUid(Atom10MappingUtils.toId((IdType)val));
                    continue;
                }
                LOG.warn((Object)("Unexpected JAXB Element: " + ToStringBuilder.reflectionToString((Object)val)));
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                ret.getOtherElements().add(e);
                continue;
            }
            LOG.warn((Object)("Unexpected Element: " + ToStringBuilder.reflectionToString((Object)o)));
        }
        return ret;
    }

    public static Link toAtomLink(LinkType link) {
        Link ret = new Link();
        ret.setBase(link.getBase());
        ret.setLang(link.getLang());
        if (link.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(link.getOtherAttributes());
        }
        ret.setHref(link.getHref());
        ret.setHreflang(link.getHreflang());
        ret.setLength(link.getLength() == null ? null : Integer.valueOf(link.getLength().intValue()));
        ret.setRel(link.getRel());
        ret.setTitle(link.getTitle());
        ret.setType(link.getType());
        return ret;
    }

    public static Id toId(IdType in) {
        Id ret = new Id();
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        ret.setIdValue(in.getValue());
        return ret;
    }

    public static Image toImage(IconType in) {
        Image ret = new Image();
        ret.setUrl(in.getValue());
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        return ret;
    }
}

