/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.backward.impl;

import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.Enclosure;
import yarfraw.core.datamodel.Id;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Source;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.rss20.elements.TCategory;
import yarfraw.generated.rss20.elements.TEnclosure;
import yarfraw.generated.rss20.elements.TGuid;
import yarfraw.generated.rss20.elements.TRssItem;
import yarfraw.generated.rss20.elements.TSource;
import yarfraw.io.parser.ElementQName;
import yarfraw.utils.XMLUtils;

class Rss20MappingUtils {
    private static final Log LOG = LogFactory.getLog(Rss20MappingUtils.class);

    private Rss20MappingUtils() {
    }

    public static ItemEntry toItem(TRssItem ti) throws YarfrawException {
        if (ti == null) {
            return null;
        }
        ItemEntry item = new ItemEntry();
        for (Object o : ti.getTitleOrDescriptionOrLink()) {
            if (o == null) continue;
            if (ti.getOtherAttributes() != null) {
                for (Map.Entry<QName, String> e : ti.getOtherAttributes().entrySet()) {
                    item.addOtherAttributes(e.getKey(), e.getValue());
                }
            }
            if (o instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)o;
                Object val = jaxbElement.getValue();
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_AUTHOR)) {
                    item.addAuthorOrCreator((String)jaxbElement.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_COMMENTS)) {
                    item.setComments((String)jaxbElement.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_DESCRIPTION)) {
                    item.setDescriptionOrSummary((String)jaxbElement.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_LINK)) {
                    item.addLink((String)jaxbElement.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_PUBDATE)) {
                    item.setPubDate((String)jaxbElement.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.RSS20_TITLE)) {
                    item.setTitle((String)jaxbElement.getValue());
                    continue;
                }
                if (val instanceof TCategory) {
                    TCategory cat = (TCategory)val;
                    item.addCategorySubject(new CategorySubject().setCategoryOrSubjectOrTerm(cat.getValue()).setDomainOrScheme(cat.getDomain()));
                    continue;
                }
                if (val instanceof TEnclosure) {
                    TEnclosure en = (TEnclosure)val;
                    item.setEnclosure(new Enclosure(en.getUrl(), en.getLength() == null ? null : en.getLength().toString(), en.getType(), en.getValue()));
                    continue;
                }
                if (val instanceof TGuid) {
                    TGuid guid = (TGuid)val;
                    item.setUid(new Id(guid.getValue()).setPermaLink(guid.isIsPermaLink()));
                    continue;
                }
                if (val instanceof TSource) {
                    TSource source = (TSource)val;
                    item.setSource(new Source(source.getUrl(), source.getValue()));
                    continue;
                }
                LOG.warn((Object)("Unexpected jaxbElement: " + ToStringBuilder.reflectionToString((Object)jaxbElement) + " this should not happen!"));
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                item.getOtherElements().add(e);
                continue;
            }
            LOG.warn((Object)("Unexpected object: " + ToStringBuilder.reflectionToString((Object)o) + " this should not happen!"));
        }
        return item;
    }
}

