/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j.handlers;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Formatter;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.log4j.ConvertedLoggingEvent;
import org.jboss.logmanager.log4j.handlers.FormatterLayout;

public final class Log4jAppenderHandler
extends ExtHandler {
    private volatile Appender appender = null;
    private final boolean applyLayout;
    private static final AtomicReferenceFieldUpdater<Log4jAppenderHandler, Appender> appenderUpdater = AtomicReferenceFieldUpdater.newUpdater(Log4jAppenderHandler.class, Appender.class, "appender");

    public Log4jAppenderHandler(Appender appender) {
        this(appender, false);
    }

    public Log4jAppenderHandler(Appender appender, boolean applyLayout) {
        appenderUpdater.set(this, appender);
        this.applyLayout = applyLayout;
        if (applyLayout) {
            appender.setLayout(null);
        }
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender appender) {
        Log4jAppenderHandler.checkAccess();
        appenderUpdater.set(this, appender);
        if (this.applyLayout && appender != null) {
            Formatter formatter = this.getFormatter();
            appender.setLayout((Layout)(formatter == null ? null : new FormatterLayout(formatter)));
        }
    }

    public void setFormatter(Formatter newFormatter) throws SecurityException {
        Appender appender;
        if (this.applyLayout && (appender = this.appender) != null) {
            appender.setLayout((Layout)new FormatterLayout(newFormatter));
        }
        super.setFormatter(newFormatter);
    }

    protected void doPublish(ExtLogRecord record) {
        Appender appender = this.appender;
        if (appender == null) {
            throw new IllegalStateException("Appender is closed");
        }
        ConvertedLoggingEvent event = new ConvertedLoggingEvent(record);
        appender.doAppend((LoggingEvent)event);
        super.doPublish(record);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        Log4jAppenderHandler.checkAccess();
        Appender appender = appenderUpdater.getAndSet(this, null);
        if (appender != null) {
            appender.close();
        }
    }
}

