/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.metadata.StandardMetaData;
import org.jboss.mx.server.ExceptionHandler;

public class StandardMBean
implements DynamicMBean {
    private static final Logger log = Logger.getLogger(StandardMBean.class);
    private Object implementation;
    private Class mbeanInterface;
    private MBeanInfo cachedMBeanInfo;

    public StandardMBean(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = implementation;
        this.mbeanInterface = mbeanInterface;
        MBeanInfo info = this.buildMBeanInfo(implementation, mbeanInterface);
        this.cacheMBeanInfo(info);
    }

    protected StandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = this;
        this.mbeanInterface = mbeanInterface;
        MBeanInfo info = this.buildMBeanInfo(this.implementation, mbeanInterface);
        this.cacheMBeanInfo(info);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        this.implementation = implementation;
    }

    public Class getImplementationClass() {
        return this.implementation.getClass();
    }

    public final Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Method method = this.implementation.getClass().getMethod("get" + attribute, null);
            return method.invoke(this.implementation, new Object[0]);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot get attribute: " + attribute);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Class[] clArr = null;
            if (attribute.getValue() != null) {
                clArr = new Class[]{attribute.getValue().getClass()};
            }
            Method method = this.implementation.getClass().getMethod("set" + attribute.getName(), clArr);
            method.invoke(this.implementation, attribute.getValue());
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot set attribute: " + attribute);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            AttributeList attrList = new AttributeList(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                String name = attributes[i];
                Object value = this.getAttribute(name);
                attrList.add(new Attribute(name, value));
            }
            return attrList;
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            throw new RuntimeException("Cannot get attributes", result);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            AttributeList attrList = new AttributeList(attributes.size());
            for (Attribute attr : attributes) {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                attrList.add(new Attribute(name, value));
            }
            return attrList;
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            throw new RuntimeException("Cannot set attributes", result);
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Class[] sigcl = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                sigcl[i] = this.loadClass(signature[i]);
            }
            Method method = this.implementation.getClass().getMethod(actionName, sigcl);
            return method.invoke(this.implementation, params);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot invoke: " + actionName);
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = LoaderRepository.getNativeClassForName(className);
        if (clazz == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            clazz = cl.loadClass(className);
        }
        return clazz;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            try {
                info = this.buildMBeanInfo(this.implementation, this.mbeanInterface);
                this.cacheMBeanInfo(info);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Unexcepted exception", (Throwable)e);
                throw new IllegalStateException("Unexcepted exception " + e.toString());
            }
        }
        return info;
    }

    protected String getClassName(MBeanInfo info) {
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getDescription(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected String getParameterName(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected int getImpact(MBeanOperationInfo info) {
        return info.getImpact();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] constructors, Object implementation) {
        if (implementation == this) {
            return constructors;
        }
        return null;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this.cachedMBeanInfo = info;
    }

    private final MBeanInfo buildMBeanInfo(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        String description;
        String name;
        String description2;
        MBeanParameterInfo[] parameters;
        int i;
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        StandardMetaData metaData = new StandardMetaData(implementation, mbeanInterface);
        this.mbeanInterface = metaData.getMBeanInterface();
        MBeanInfo info = metaData.build();
        String className = this.getClassName(info);
        String mainDescription = this.getDescription(info);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        MBeanConstructorInfo[] constructors = info.getConstructors();
        MBeanOperationInfo[] operations = info.getOperations();
        MBeanNotificationInfo[] notifications = info.getNotifications();
        for (i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attribute = attributes[i];
            String description3 = this.getDescription(attribute);
            attributes[i] = new MBeanAttributeInfo(attribute.getName(), attribute.getType(), description3, attribute.isReadable(), attribute.isWritable(), attribute.isIs());
        }
        if (implementation == this) {
            constructors = this.getConstructors(constructors, this);
            for (i = 0; i < constructors.length; ++i) {
                MBeanConstructorInfo constructor = constructors[i];
                parameters = constructor.getSignature();
                for (int j = 0; j < parameters.length; ++j) {
                    MBeanParameterInfo param = parameters[j];
                    description2 = this.getDescription(constructor, param, j);
                    name = this.getParameterName(constructor, param, j);
                    parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
                }
                description = this.getDescription(constructor);
                constructors[i] = new MBeanConstructorInfo(constructor.getName(), description, parameters);
            }
        } else {
            constructors = new MBeanConstructorInfo[]{};
        }
        for (i = 0; i < operations.length; ++i) {
            MBeanOperationInfo operation = operations[i];
            parameters = operation.getSignature();
            for (int j = 0; j < parameters.length; ++j) {
                MBeanParameterInfo param = parameters[j];
                description2 = this.getDescription(operation, param, j);
                name = this.getParameterName(operation, param, j);
                parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
            }
            description = this.getDescription(operation);
            int impact = this.getImpact(operation);
            operations[i] = new MBeanOperationInfo(operation.getName(), description, parameters, operation.getReturnType(), impact);
        }
        info = new MBeanInfo(className, mainDescription, attributes, constructors, operations, notifications);
        return info;
    }
}

