/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanNotificationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import org.jboss.mx.util.Serialization;

public class ModelMBeanNotificationInfo
extends MBeanNotificationInfo
implements DescriptorAccess,
Cloneable {
    private Descriptor descriptor = null;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;

    public ModelMBeanNotificationInfo(String[] notifTypes, String name, String description) {
        super(notifTypes, name, description);
        this.setDescriptor(this.createDefaultDescriptor());
    }

    public ModelMBeanNotificationInfo(String[] notifTypes, String name, String description, Descriptor descriptor) {
        super(notifTypes, name, description);
        this.setDescriptor(descriptor);
    }

    public ModelMBeanNotificationInfo(ModelMBeanNotificationInfo info) {
        this(info.getNotifTypes(), info.getName(), info.getDescription(), info.getDescriptor());
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor == null) {
            inDescriptor = this.createDefaultDescriptor();
        }
        if (inDescriptor.isValid() && this.isNotificationDescriptorValid(inDescriptor)) {
            this.descriptor = inDescriptor;
        }
    }

    private boolean isNotificationDescriptorValid(Descriptor inDescriptor) {
        String name = (String)inDescriptor.getFieldValue("name");
        if (!name.equals(this.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid name, expected '" + this.getName() + "' but got: " + name));
        }
        String descriptorType = (String)inDescriptor.getFieldValue("descriptorType");
        if (!"notification".equalsIgnoreCase(descriptorType)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptorType, for notification '" + name + "' expected 'notification' but got: " + descriptorType));
        }
        return true;
    }

    public Object clone() {
        ModelMBeanNotificationInfo clone = (ModelMBeanNotificationInfo)super.clone();
        clone.descriptor = (Descriptor)this.descriptor.clone();
        return clone;
    }

    public String toString() {
        return super.toString();
    }

    private Descriptor createDefaultDescriptor() {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", this.getName());
        descr.setField("displayName", this.getName());
        descr.setField("severity", "5");
        descr.setField("descriptorType", "notification");
        return descr;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        switch (Serialization.version) {
            case 10: {
                this.descriptor = (Descriptor)getField.get("ntfyDescriptor", null);
                break;
            }
            default: {
                this.descriptor = (Descriptor)getField.get("notificationDescriptor", null);
            }
        }
        if (this.descriptor == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        switch (Serialization.version) {
            case 10: {
                putField.put("ntfyDescriptor", this.descriptor);
                break;
            }
            default: {
                putField.put("notificationDescriptor", this.descriptor);
            }
        }
        oos.writeFields();
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -5211564525059047097L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ntfyDescriptor", Descriptor.class)};
                break;
            }
            default: {
                serialVersionUID = -7445681389570207141L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("notificationDescriptor", Descriptor.class)};
            }
        }
    }
}

