/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType
implements Serializable {
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient int cachedHashCode = 0;
    private transient String cachedToString = null;
    private static final long serialVersionUID = -5366242454346948798L;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super(CompositeData.class.getName(), typeName, description);
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("null or empty itemNames");
        }
        if (itemDescriptions == null || itemDescriptions.length == 0) {
            throw new IllegalArgumentException("null or empty itemDescriptions");
        }
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("null or empty itemTypes");
        }
        if (itemNames.length != itemDescriptions.length) {
            throw new IllegalArgumentException("wrong number of itemDescriptions");
        }
        if (itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("wrong number of itemTypes");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            if (itemNames[i] == null) {
                throw new IllegalArgumentException("null item name " + i);
            }
            String itemName = itemNames[i].trim();
            if (itemName.length() == 0) {
                throw new IllegalArgumentException("empty item name " + i);
            }
            if (this.nameToDescription.containsKey(itemName)) {
                throw new OpenDataException("duplicate item name " + itemName);
            }
            if (itemDescriptions[i] == null) {
                throw new IllegalArgumentException("null item description " + i);
            }
            String itemDescription = itemDescriptions[i].trim();
            if (itemDescription.length() == 0) {
                throw new IllegalArgumentException("empty item description " + i);
            }
            if (itemTypes[i] == null) {
                throw new IllegalArgumentException("null item type " + i);
            }
            this.nameToDescription.put(itemName, itemDescription);
            this.nameToType.put(itemName, itemTypes[i]);
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        if (itemName == null) {
            return null;
        }
        return (String)this.nameToDescription.get(itemName);
    }

    public OpenType getType(String itemName) {
        if (itemName == null) {
            return null;
        }
        return (OpenType)this.nameToType.get(itemName);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof CompositeData)) {
            return false;
        }
        return this.equals(((CompositeData)obj).getCompositeType());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompositeType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CompositeType other = (CompositeType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Iterator thisNames = this.keySet().iterator();
        Iterator otherNames = other.keySet().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = (String)thisNames.next();
            if (!thisName.equals(otherName = (String)otherNames.next())) {
                return false;
            }
            if (this.getType(thisName).equals(other.getType(otherName))) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode();
        Iterator<Object> i = this.nameToType.values().iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        i = this.nameToDescription.keySet().iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("\n");
        Iterator thisNames = this.keySet().iterator();
        while (thisNames.hasNext()) {
            String thisName = (String)thisNames.next();
            buffer.append("name=");
            buffer.append(thisName);
            buffer.append(" type=");
            buffer.append(this.getType(thisName));
            if (!thisNames.hasNext()) continue;
            buffer.append("\n");
        }
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

