/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.RequiredModelMBean;
import org.jboss.mx.server.RawDynamicInvoker;

public class RequiredModelMBeanInvoker
extends RawDynamicInvoker {
    RequiredModelMBean mbean;

    public RequiredModelMBeanInvoker(DynamicMBean resource) {
        super(resource);
        this.mbean = (RequiredModelMBean)resource;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return super.getAttribute(name);
        }
        catch (ReflectionException e) {
            Exception ex = e.getTargetException();
            if (!(ex instanceof ClassNotFoundException) && !(ex instanceof NoSuchMethodException)) {
                this.log.debug((Object)"Rewrapping reflection exception: ", (Throwable)e);
                throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
            }
            throw e;
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute"));
        }
        try {
            super.setAttribute(attribute);
        }
        catch (ReflectionException e) {
            Exception ex = e.getTargetException();
            if (!(ex instanceof ClassNotFoundException) && !(ex instanceof NoSuchMethodException)) {
                this.log.debug((Object)"Rewrapping reflection exception: ", (Throwable)e);
                throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
            }
            throw e;
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
        }
        return super.getAttributes(attributes);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attributes"));
        }
        return super.setAttributes(attributes);
    }

    public Object invoke(String name, Object[] args, String[] signature) throws MBeanException, ReflectionException {
        Object value;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null operation"));
        }
        if (name.equals("getNotificationInfo")) {
            value = this.mbean.getNotificationInfo();
        } else {
            try {
                value = super.invoke(name, args, signature);
            }
            catch (RuntimeMBeanException e) {
                throw new MBeanException(e.getTargetException(), e.getMessage());
            }
            catch (ReflectionException e) {
                Exception ex = e.getTargetException();
                if (!(ex instanceof ClassNotFoundException) && !(ex instanceof NoSuchMethodException)) {
                    this.log.debug((Object)"Rewrapping reflection exception: ", (Throwable)e);
                    throw new MBeanException(new ServiceNotFoundException(ex.getMessage()), e.getMessage());
                }
                throw e;
            }
        }
        return value;
    }
}

