/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class PropertyAccess {
    public static String getProperty(String name) {
        return PropertyAccess.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        PropertyReadAction action = new PropertyReadAction(name, defaultValue);
        String property = (String)AccessController.doPrivileged(action);
        return property;
    }

    public static String setProperty(String name, String value) {
        PropertyWriteAction action = new PropertyWriteAction(name, value);
        String property = (String)AccessController.doPrivileged(action);
        return property;
    }

    static class PropertyWriteAction
    implements PrivilegedAction {
        private String name;
        private String value;

        PropertyWriteAction(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Object run() {
            return System.setProperty(this.name, this.value);
        }
    }

    static class PropertyReadAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyReadAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

