/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;

@Name(value="org.jboss.seam.ui.renderStampStore")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0, value=false)
@AutoCreate
@BypassInterceptors
public class RenderStampStore
implements Serializable {
    int maxSize = 100;
    Map<String, RenderStamp> store = new ConcurrentHashMap<String, RenderStamp>();

    public String storeStamp(String stamp) {
        String key;
        if (this.maxSize > 0 && this.store.size() == this.maxSize) {
            Date oldest = null;
            String oldestSigniture = null;
            for (String sig : this.store.keySet()) {
                RenderStamp s = this.store.get(sig);
                if (oldest != null && !s.timeStamp.before(oldest)) continue;
                oldestSigniture = sig;
            }
            this.store.remove(oldestSigniture);
        }
        RenderStamp s = new RenderStamp();
        s.stamp = stamp;
        s.timeStamp = new Date();
        while (!this.store.containsKey(key = UUID.randomUUID().toString())) {
        }
        this.store.put(key, s);
        return key;
    }

    public void removeStamp(String viewSigniture) {
        this.store.remove(viewSigniture);
    }

    public String getStamp(String viewSigniture) {
        RenderStamp s = this.store.get(viewSigniture);
        if (s != null) {
            return this.store.get((Object)viewSigniture).stamp;
        }
        return null;
    }

    public static RenderStampStore instance() {
        return (RenderStampStore)Component.getInstance(RenderStampStore.class);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    class RenderStamp {
        String stamp;
        Date timeStamp;

        RenderStamp() {
        }
    }
}

