/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rss.ui;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.rss.ui.SyndicationComponent;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Text;

public class UIEntry
extends SyndicationComponent {
    private static final String COMPONENT_TYPE = "org.jboss.seam.rss.ui.UIEntry";
    private String uid;
    private String title;
    private String link;
    private String author;
    private String summary;
    private Text.TextType textFormat = Text.TextType.html;
    private Date published;
    private Date updated;

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    private Text makeText(String textString) {
        Text text = new Text(this.textFormat);
        text.setText(textString);
        return text;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ChannelFeed channelFeed = (ChannelFeed)Contexts.getEventContext().get("theFeed");
        ItemEntry itemEntry = new ItemEntry();
        itemEntry.setUid(this.getUid());
        itemEntry.setTitle(this.makeText(this.getTitle()));
        itemEntry.addLink(new String[]{this.getLink()});
        String author = this.getAuthor();
        if (author != null) {
            Person authorPerson = new Person();
            authorPerson.setName(author);
            itemEntry.addAuthorOrCreator(new Person[]{authorPerson});
        }
        itemEntry.setDescriptionOrSummary(this.makeText(this.getSummary()));
        if (this.getUpdated() != null) {
            itemEntry.setUpdatedDate(this.getUpdated(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        if (this.getPublished() != null) {
            itemEntry.setPubDate(this.getPublished(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        channelFeed.addItem(new ItemEntry[]{itemEntry});
    }

    public String getTitle() {
        return (String)this.valueOf("title", this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLink() {
        return (String)this.valueOf("link", this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getAuthor() {
        return (String)this.valueOf("author", this.author);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSummary() {
        return (String)this.valueOf("summary", this.summary);
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Date getPublished() {
        return (Date)this.valueOf("published", this.published);
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public Date getUpdated() {
        return (Date)this.valueOf("updated", this.updated);
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getUid() {
        return (String)this.valueOf("uid", this.uid);
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Text.TextType getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(Text.TextType textFormat) {
        this.textFormat = textFormat;
    }
}

