/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Assert;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.UnknownDataType;

public class Assertion {
    private static final ColumnComparator COLUMN_COMPARATOR = new ColumnComparator();

    private Assertion() {
    }

    public static void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        if (expectedDataSet == actualDataSet) {
            return;
        }
        String[] expectedNames = Assertion.getSortedUpperTableNames(expectedDataSet);
        String[] actualNames = Assertion.getSortedUpperTableNames(actualDataSet);
        Assert.assertEquals((String)"table count", (int)expectedNames.length, (int)actualNames.length);
        int i = 0;
        while (i < expectedNames.length) {
            if (!actualNames[i].equals(expectedNames[i])) {
                Assert.fail((String)("expected tables " + Arrays.asList(expectedNames) + " but was " + Arrays.asList(actualNames)));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < expectedNames.length) {
            String name = expectedNames[i2];
            Assertion.assertEquals(expectedDataSet.getTable(name), actualDataSet.getTable(name));
            ++i2;
        }
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        if (expectedTable == actualTable) {
            return;
        }
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        Column[] expectedColumns = Assertion.getSortedColumns(expectedMetaData);
        Column[] actualColumns = Assertion.getSortedColumns(actualMetaData);
        Assert.assertEquals((String)("column count (table=" + expectedTableName + ")"), (int)expectedColumns.length, (int)actualColumns.length);
        int i = 0;
        while (i < expectedColumns.length) {
            String actualName;
            String expectedName = expectedColumns[i].getColumnName();
            if (!expectedName.equalsIgnoreCase(actualName = actualColumns[i].getColumnName())) {
                Assert.fail((String)("expected columns " + Assertion.getColumnNamesAsString(expectedColumns) + " but was " + Assertion.getColumnNamesAsString(actualColumns) + " (table=" + expectedTableName + ")"));
            }
            ++i;
        }
        Assert.assertEquals((String)("row count (table=" + expectedTableName + ")"), (int)expectedTable.getRowCount(), (int)actualTable.getRowCount());
        int i2 = 0;
        while (i2 < expectedTable.getRowCount()) {
            int j = 0;
            while (j < expectedColumns.length) {
                Column expectedColumn = expectedColumns[j];
                Column actualColumn = actualColumns[j];
                String columnName = expectedColumn.getColumnName();
                Object expectedValue = expectedTable.getValue(i2, columnName);
                Object actualValue = actualTable.getValue(i2, columnName);
                DataType dataType = Assertion.getComparisonDataType(expectedTableName, expectedColumn, actualColumn);
                if (dataType.compare(expectedValue, actualValue) != 0) {
                    Assert.fail((String)("value (table=" + expectedTableName + ", " + "row=" + i2 + ", col=" + columnName + "): expected:<" + expectedValue + "> but was:<" + actualValue + ">"));
                }
                ++j;
            }
            ++i2;
        }
    }

    static DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn) {
        DataType expectedDataType = expectedColumn.getDataType();
        DataType actualDataType = actualColumn.getDataType();
        if (!expectedDataType.getClass().isInstance(actualDataType)) {
            if (expectedDataType instanceof UnknownDataType) {
                return actualDataType;
            }
            if (actualDataType instanceof UnknownDataType) {
                return expectedDataType;
            }
            Assert.fail((String)("Incompatible data types: " + expectedDataType + ", " + actualDataType + " (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")"));
        }
        return expectedDataType;
    }

    private static Column[] getSortedColumns(ITableMetaData metaData) throws DataSetException {
        Column[] columns = metaData.getColumns();
        Column[] sortColumns = new Column[columns.length];
        System.arraycopy(columns, 0, sortColumns, 0, columns.length);
        Arrays.sort(sortColumns, COLUMN_COMPARATOR);
        return sortColumns;
    }

    private static String getColumnNamesAsString(Column[] columns) {
        String[] names = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            names[i] = column.getColumnName();
            ++i;
        }
        return Arrays.asList(names).toString();
    }

    private static String[] getSortedUpperTableNames(IDataSet dataSet) throws DataSetException {
        Object[] names = dataSet.getTableNames();
        int i = 0;
        while (i < names.length) {
            names[i] = ((String)names[i]).toUpperCase();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }

    private static class ColumnComparator
    implements Comparator {
        private ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            Column column1 = (Column)o1;
            Column column2 = (Column)o2;
            String columnName1 = column1.getColumnName();
            String columnName2 = column2.getColumnName();
            return columnName1.compareToIgnoreCase(columnName2);
        }
    }
}

